% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglm4twin.R
\docType{data}
\name{t0psqi}
\alias{t0psqi}
\title{Sleep’s quality}
\format{
a \code{data.frame} with 502 records and 8 variables.
}
\source{
Bonat, W. H. and Hjelmborg, J. v. B. (2020) Multivariate Generalized
    Linear Models for Twin and Family data. to appear.
}
\usage{
data(t0psqi)
}
\description{
Data set concerning sleep’s quality in a sample of
    250 (135 DZ and 116 MZ) Danish twin pairs. The traits are cortisone
    levels when waking up (T0) and PSQI (Pittsburgh Sleep Quality Index).
    It is a simulated data set based on the parameter estimates obtained
    fitting the model to a motivating real data set. The code for the simulation
    is available in the folder data-raw.

\itemize{

\item \code{Twin_pair} - Code of twin within the pair (1 and 2).

\item \code{Twin_id} - Twin code.

\item \code{Age} - Twin age.

\item \code{Type} - Twin zygosity (DZ - dizygotic; MZ - monozygotic).

\item \code{Gender} - Gender (Male and Female).

\item \code{Group} - Treatment group, it is categorical covariate for composing
                     the linear predictor.

\item \code{T0} - Cortisone levels when waking up (continuous trait).

\item \code{PSQI} - Pittsburgh Sleep Quality Index (bounded trait) divided
                    by 21 (scale maximum).
}
}
\examples{
require(mglm4twin)
form_T0 <- T0 ~ Age + Gender + Group + Type*Twin_pair
form_PSQI <- PSQI ~ Age + Gender + Group + Type*Twin_pair
AE <- mt_twin(N_DZ = 135, N_MZ = 116, n_resp = 2, model = "AE")
fit_AE <- mglm4twin(linear_pred = c(form_T0,  form_PSQI),
                   matrix_pred = AE,
                   link = c("log","logit"),
                   variance = c("tweedie","binomialP"),
                   control_algorithm = list(tuning = 0.25, max_iter = 100),
                   power_fixed = c(FALSE,FALSE), data = t0psqi)
}
\keyword{datasets}
