% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglm4twin.R
\docType{data}
\name{psydis}
\alias{psydis}
\title{Psychiatric disorders}
\format{
a \code{data.frame} with 2060 records and 4 variables.
}
\source{
Neale, M. C. and Maes, H. H. (2004) . Methodology for Genetic Studies
    of Twins and Families. Tech. rep., Virginia Common wealth University,
    Department of Psychiatry.

Rabe-Hesketh, S., Skrondal, A. and Gjessing, H. K. (2008)
    Biometrical modeling of twin and family data using standard mixed
    model software. Biometrics, 64, 280–288.

Bonat, W. H. and v. B. Hjelmborg, J. (2020) Multivariate Generalized
    Linear Models for Twin and Family data. to appear.
}
\usage{
data(psydis)
}
\description{
Psychiatric disorders in 1030 (440 DZ and 590 MZ) Caucasian
    female twin-pairs sampled from the Virginia Twin Registry.
    Lifetime psychiatric illness is a binary trait and was diagnosed using an
    adapted version of the Structured Clinical Interview for DSM-II-R Diagnosis.

\itemize{

\item \code{y} - Binary trait (disease presence YES - 1; NO - 0).

\item \code{Group} - Twin zygosity (DZ - dizygotic; MZ - monozygotic).

\item \code{Twin} - Code of twin pair.

\item \code{Twin_pair} - Code of twin within the pair (1 and 2).

}
}
\examples{
require(mglm4twin)
data(psydis, package="mglm4twin")
ex1_form <- y ~ 1
ex1_AE <- mt_twin(N_DZ = 440, N_MZ = 590, n_resp = 1, model = "AE")
ex1_AE <- mglm4twin(c(ex1_form), matrix_pred = ex1_AE,
                    link = c("logit"), variance = c("binomialP"),
                   data = psydis)
summary(ex1_AE, model = "AE")
summary(ex1_AE, model = "AE", biometric = TRUE)
}
\keyword{datasets}
