% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_variance_function.R
\name{mt_variance_function}
\alias{mt_variance_function}
\alias{mt_tweedie}
\alias{mt_binomialP}
\alias{mt_binomialPQ}
\alias{mt_constant}
\title{Variance Functions}
\source{
Bonat, W. H. and Jorgensen, B. (2016) Multivariate
    covariance generalized linear models.
    Journal of Royal Statistical Society - Series C 65:649--675.
}
\usage{
mt_variance_function(mu, power, Ntrial, variance,
                           derivative_power, derivative_mu)

mt_tweedie(mu, power, Ntrial, derivative_power, derivative_mu)

mt_binomialP(mu, power, Ntrial,
                    derivative_power, derivative_mu)

mt_binomialPQ(mu, power, Ntrial,
                     derivative_power, derivative_mu)

mt_constant(mu, power, Ntrial, derivative_power, derivative_mu)
}
\arguments{
\item{mu}{a numeric vector. In general the output from
\code{\link{mt_link_function}}.}

\item{power}{a numeric value (\code{tweedie} and \code{binomialP}) or
a vector (\code{binomialPQ}) of the power parameters.}

\item{Ntrial}{number of trials, useful only when dealing with
binomial response variables.}

\item{variance}{a string specifying the name (\code{constant, tweedie, binomialP
or binomialPQ}) of the variance function.}

\item{derivative_power}{logical if compute (TRUE) or not (FALSE) the
derivatives with respect to the power parameter.}

\item{derivative_mu}{logical if compute (TRUE) or not (FALSE) the
derivative with respect to the mu parameter.}
}
\value{
A list with from one to four elements depending on the
    arguments.
}
\description{
Compute the variance function and its derivatives with
respect to regression, dispersion and power parameters.
}
\details{
The function \code{mt_variance_function} computes three
    features related with the variance function. Depending on the
    logical arguments, the function returns \eqn{V^{1/2}} and its
    derivatives with respect to the parameters power and mu,
    respectivelly.  The output is a named list, completely
    informative about what the function has been computed.  For
    example, if \code{derivative_power = TRUE} and \code{derivative_mu = TRUE}.
    The output will be a list, with three elements: V_sqrt, D_V_sqrt_power and
    D_V_sqrt_mu.
}
\examples{
x1 <- seq(-1, 1, l = 5)
X <- model.matrix(~x1)
mu <- mt_link_function(beta = c(1, 0.5), X = X, offset = NULL,
                       link = "logit")
mt_variance_function(mu = mu$mu, power = c(2, 1), Ntrial = 1,
                     variance = "binomialPQ",
                     derivative_power = TRUE, derivative_mu = TRUE)

}
\seealso{
\code{\link{mt_link_function}}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
