% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_initial_values.R
\name{mt_initial_values}
\alias{mt_initial_values}
\title{Automatic Initial Values}
\usage{
mt_initial_values(linear_pred, matrix_pred, link, variance,
                         offset, Ntrial, contrasts, data)
}
\arguments{
\item{linear_pred}{a list of formula see \code{\link[stats]{formula}}
for details.}

\item{matrix_pred}{a list of known matrices to be used on the matrix
linear predictor. \cr
See \code{\link[mglm4twin]{mt_matrix_linear_predictor}} for details.}

\item{link}{a list of link functions names, see
\code{\link[mglm4twin]{mglm4twin}} for details.}

\item{variance}{a list of variance functions names, see
\code{\link[mglm4twin]{mglm4twin}} for details.}

\item{offset}{a list of offset values if any.}

\item{Ntrial}{a list of the number of trials on Bernoulli
experiments. It is useful only for \code{"binomialP"} and
\code{"binomialPQ"} variance functions.}

\item{contrasts}{list of contrasts to be used in the
\code{\link[stats]{model.matrix}}.}

\item{data}{data frame.}
}
\value{
Return a list of initial values to be used while fitting
    in the \code{mglm4twin} function.
}
\description{
This function provides initial values to be used when
fitting multivariate generalized linear models by using
the function \code{fit_mglm}. In general the users do not need to use
this function, since it is already employed when setting the argument
\code{control_initial = "automatic"} in the \code{mglm4twin} function.
However, if the users want to change some of the initial values,
this function can be useful.
}
\details{
To obtain initial values for multivariate covariance
generalized linear models the function \cr \code{mt_initial_values} fits
a generalized linear model (GLM) using the function \code{glm} with
the specified linear predictor and link function for each response
variables considering independent observations. The \code{family}
argument is always specified as \code{quasi}. The link function depends
on the specification of the argument \code{link}.
The variance function is always specified as \code{"mu"} the only
excession appears when using \code{variance = "constant"} then the
family argument in the \code{glm} function is specified as
\code{quasi(link = link, variance = "constant")}. The estimated value
of the dispersion parameter from the \code{glm} function is used as
initial value for the first component of the matrix linear predictor,
for all other components the value zero is used.
The value of the power parameter is always started at 1.
In the cases of multivariate models the correlation between response
variables is always started at 0.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
