% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_build_sigma.R
\name{mt_build_sigma}
\alias{mt_build_sigma}
\title{Build variance-covariance matrix}
\usage{
mt_build_sigma(
  mu,
  tau,
  power,
  Z,
  Ntrial,
  variance,
  power_fixed,
  inverse = FALSE,
  compute_derivative_beta = TRUE
)
}
\arguments{
\item{mu}{List with expected values and derivatives. In general the output from
\code{\link{mt_link_function}}.}

\item{tau}{A numeric vector.}

\item{power}{A list of numeric or numeric vector. It should be one number for
all variance functions except binomialPQ, in that case the
argument specifies both p and q. Each slot of the list should specify the
power parameter for each response variable.}

\item{Z}{A list of matrices.}

\item{Ntrial}{Number of trials for binomial data.}

\item{variance}{String specifing the variance function: constant,
tweedie, poisson_tweedie, binomialP or binomialPQ.}

\item{power_fixed}{Logical if the power parameter is fixed at initial
value (TRUE). In the case power_fixed = FALSE the power parameter
will be estimated.}

\item{compute_derivative_beta}{Logical. Compute or not the derivative
with respect to regression parameters.}
}
\value{
A list with \eqn{\Sigma},
    \eqn{\Sigma^{-1}} and the derivative of \eqn{\Sigma} with respect
    to the power, tau and beta parameters.
}
\description{
This function builds a variance-covariance matrix, based
    on the variance function and Omega matrix.
}
\seealso{
\code{\link{mt_link_function}},
    \code{\link{mt_variance_function}}, \code{\link{mt_build_omega}}.
}
\author{
Wagner Hugo Bonat,  \email{wbonat@ufpr.br}
}
\keyword{internal}
