% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_main_function.R
\name{mglm4twin}
\alias{mglm4twin}
\title{Fitting Multivariate Covariance Generalized Linear Models to Twin data}
\source{
Bonat, W. H. and Jorgensen, B. (2016) Multivariate
    covariance generalized linear models.
    Journal of Royal Statistical Society - Series C 65:649--675.

Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mglm4twin(linear_pred, matrix_pred, link, variance,
       offset, Ntrial, power_fixed, weights, data, control_initial,
       contrasts, control_algorithm)
}
\arguments{
\item{linear_pred}{a list of formula see \code{\link[stats]{formula}}
for details.}

\item{matrix_pred}{a list of matrices, in general the output of \code{mt_twin}
function.}

\item{link}{a list of link functions names. Options are:
\code{"logit"}, \code{"probit"}, \code{"cauchit"}, \code{"cloglog"},
\code{"loglog"}, \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"1/mu^2"} and \code{"inverse"}.
See \code{\link{mt_link_function}} for details.}

\item{variance}{a list of variance functions names.
Options are: \code{"constant"}, \code{"tweedie"},
\code{"poisson_tweedie"}, \code{"binomialP"} and \code{"binomialPQ"}. \cr
See \code{\link{mt_variance_function}} for details.}

\item{offset}{a list of offset values if any.}

\item{Ntrial}{a list of number of trials on Bernoulli
experiments. It is useful only for \code{binomialP} and
\code{binomialPQ} variance functions.}

\item{power_fixed}{a list of logicals indicating if the values of the
power parameter should be estimated or not.}

\item{weights}{A list of weights for model fitting. Each element of
the list should be a vector of weights of size equals the number of
observations. Missing observations should be annotated as NA.}

\item{data}{a data frame.}

\item{control_initial}{a list of initial values for the fitting
algorithm. If no values are supplied automatic initial values
will be provided by the function \code{\link{mt_initial_values}}.}

\item{contrasts}{extra arguments to passed to
\code{\link[stats]{model.matrix}}.}

\item{control_algorithm}{a list of arguments to be passed for the
fitting algorithm. See \code{\link[mglm4twin]{fit_mglm}} for
details.}
}
\value{
mcglm returns an object of class 'mcglm'.
}
\description{
The function \code{mglm4twin} is used for fitting multivariate
    generalized linear models to twin data. The models are specified
    by a set of lists giving a symbolic
    description of the linear and matrix linear predictors.
    The user can choose between a list of link and variance
    functions. The models are fitted using an estimating function
    approach, combining the quasi-score function for the regression
    parameters and the Pearson estimating function for the covariance
    parameters. For details see Bonat and Jorgensen (2016).
}
\seealso{
\code{fit_mglm}, \code{mt_link_function} and
\code{mt_variance_function}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
