% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_gof.R
\name{gof}
\alias{gof}
\title{Measures of Goodness-of-Fit}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.

Wang, M. (2014). Generalized Estimating Equations in Longitudinal Data
Analysis: A Review and Recent Developments. Advances in Statistics, 1(1)1--13.
}
\usage{
gof(object)
}
\arguments{
\item{object}{an object or a list of objects representing a model
of \code{mglm4twin} class.}
}
\value{
Returns a data frame containing goodness-of-fit measures.
}
\description{
Extract the pseudo Gaussian log-likelihood (plogLik),
pseudo Akaike Information Criterion (pAIC), pseudo Kullback-Leibler
Information Criterion (pKLIC) and pseudo Bayesian Information Criterion (pBIC)
for objects of \code{mglm4twin} class.
}
\seealso{
\code{plogLik}, \code{pAIC}, \code{pKLIC} and \code{pBIC}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
