% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_auxiliar.R
\name{ef_sandwich}
\alias{ef_sandwich}
\alias{ef_sandwich_negative}
\alias{ef_sandwich_power}
\alias{ef_sandwich_cholesky}
\alias{ef_multiply}
\alias{ef_multiply2}
\title{Matrix product in sandwich form}
\usage{
ef_sandwich(middle, bord1, bord2)

ef_sandwich_negative(middle, bord1, bord2)

ef_sandwich_power(middle, bord1, bord2)

ef_sandwich_cholesky(bord1, middle, bord2)

ef_multiply(bord1, bord2)

ef_multiply2(bord1, bord2)
}
\arguments{
\item{middle}{A matrix.}

\item{bord1}{A matrix.}

\item{bord2}{A matrix.}
}
\value{
The matrix product \code{bord1 * middle * bord2}.
}
\description{
The function \code{ef_sandwich} is just an auxiliar
    function to compute product matrix in the sandwich form
    \code{bord1 * middle * bord2}. An special case appears when
    computing the derivative of the covariance matrix with respect to
    the power parameter. Always the bord1 and bord2 should be
    diagonal matrix. If it is not true, this product is too slow.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
