% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglm4twin.R
\docType{data}
\name{bpdrds}
\alias{bpdrds}
\title{Bronchopulmonary dysplasia and respiratory distress syndrome on preterm infants}
\format{
a \code{data.frame} with 400 records and 8 variables.
}
\source{
Feng, R., Zhou, G., Zhang, M. and Zhang, H. (2009)
    Analysis of twin data using sas. Biometrics, 65, 584–589.

Bonat, W. H. and Hjelmborg, J. v. B. (2020) Multivariate Generalized
    Linear Models for Twin and Family data. to appear.
}
\usage{
data(bmi)
}
\description{
We use the dataset analysed by Feng et al. (2009) regarding
    bronchopulmonary dysplasia (BPD) and respiratory distress syndrome (RDS)
    on preterm infants. Both diseases are lung related and expected to have a
    genetic component. The dataset consists of 200 twin-pairs being 137 DZ and 63 MZ.
    Additionally, we considered the covariates: birth weight (BW),
    gestation age (GA) and gender (female and male).

\itemize{

\item \code{Twin} - Code of twin pair.

\item \code{gender} - Twin age gender (male and female).

\item \code{GA} - Gestation age.

\item \code{BW} - Birth weight.

\item \code{RDS} - Respiratory distress syndrome (binary).

\item \code{BPD} - Bronchopulmonary dysplasia (binary).

\item \code{Group} - Twin zygosity (DZ - dizygotic; MZ - monozygotic).

\item \code{Twin_pair} - Code of twin within the pair (1 and 2).

}
}
\examples{
require(mglm4twin)
data(bpdrds, package="mglm4twin")
form_BPD <- BPD ~ BW + GA + gender + Group*Twin_pair
form_RDS <- RDS ~ BW + GA + gender + Group*Twin_pair
AE <- mt_twin(N_DZ = 137, N_MZ = 63, n_resp = 2, model = "AE")
fitAE <- mglm4twin(linear_pred = c(form_BPD, form_RDS), matrix_pred = AE,
                   link = c("logit","logit"),
                   variance = c("binomialP","binomialP"), data = bpdrds)
}
\keyword{datasets}
