% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglm4twin.R
\docType{data}
\name{bmi}
\alias{bmi}
\title{Body mass index}
\format{
a \code{data.frame} with 8542 records and 6 variables.
}
\source{
Holst, K. K. and Scheike, T. H. and Hjelmborg, J. B. (2016).
    The Liability Threshold Model for Censored twin Data. Computational
    Statistics and Data Analysis 93, pp. 324-335. doi: 10.1016/j.csda.2015.01.014

Bonat, W. H. and Hjelmborg, J. v. B. (2020) Multivariate Generalized
    Linear Models for Twin and Family data. to appear.
}
\usage{
data(bmi)
}
\description{
It is a fairly common data set from the `mets` package.
    The dataset consists of 11188 observations, however, in the `mglm4twin`
    package we considered only paired twin-pairs. Thus, we opted to circulate
    the data in this new form to avoid mistakes. The resulting dataset consists
    of 4271(2788 DZ and 1483 MZ) twin-pairs.

\itemize{

\item \code{bmi} - Continuous trait (body mass index).

\item \code{age} - Twin age.

\item \code{gender} - Twin gender (male and female).

\item \code{Group} - Twin zygosity (DZ - dizygotic; MZ - monozygotic).

\item \code{Twin} - Code of twin pair.

\item \code{Twin_pair} - Code of twin within the pair (1 and 2).

}
}
\examples{
require(mglm4twin)
data(bmi, package="mglm4twin")
form = bmi ~ Group*Twin_pair
ACE = mt_twin(N_DZ = 5576/2, N_MZ = 2966/2, n_resp = 1, model = "ACE")
fit_ACE <- mglm4twin(linear_pred = c(form), matrix_pred = ACE, data = bmi)
}
\keyword{datasets}
