% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglm4twin.R
\docType{data}
\name{anthro}
\alias{anthro}
\title{Anthropometric measures (weight and height)}
\format{
a \code{data.frame} with 1722 records and 6 variables.
}
\source{
Neale, M. C., Hunter, M. D., Pritikin, J. N., Zahery, M., Brick, T. R.,
   Kirkpatrick, R. M., Estabrook, R., Bates, T. C., Maes, H. H. and Boker, S. M. (2016)
   OpenMx 2.0: Extended structural equation and statistical modeling.
   Psychometrika, 81, 535–549.

Bonat, W. H. and Hjelmborg, J. v. B. (2020) Multivariate Generalized
    Linear Models for Twin and Family data. to appear.
}
\usage{
data(anthro)
}
\description{
Anthropometric measures (weight and height) on 861 (327 DZ and 534 MZ) twin-pairs.
Furthermore, we explore the flexibility of our proposed model class and model the dispersion.
The data set is available as an example in the OpenMx package (Neale et al., 2016).
We customize the data set for our needs, so make it available organized for
use in the mlm4twin package.

\itemize{

\item \code{weight} - Twin weight.

\item \code{height} - Twin height.

\item \code{age} - Twin age.

\item \code{Group} - Twin zygosity (DZ - dizygotic; MZ - monozygotic).

\item \code{Twin} - Twin code.

\item \code{Twin_pair} - Code of twin within the pair (1 and 2).

}
}
\examples{
require(mglm4twin)
data(anthro, package="mglm4twin")
anthro$age <- (anthro$age - mean(anthro$age))/sd(anthro$age)
anthro$weight <- (anthro$weight - mean(anthro$weight))/sd(anthro$weight)
anthro$height <- (anthro$height - mean(anthro$height))/sd(anthro$height)
form_Wt <- weight ~ age + Group*Twin_pair
form_Ht <- height ~ age + Group*Twin_pair
biv0 <- list("formE1" = ~ age, "formE2" = ~ age, "formE12" = ~ age,
             "formA1" = ~ age, "formA2" = ~ age, "formA12" = ~ age,
             "formC1" = ~ age, "formC2" = ~ age, "formC12" = ~ age)
Z_biv0 <- mt_twin(N_DZ = 327, N_MZ = 534, n_resp = 2, model = "ACE",
                 formula = biv0, data = anthro)
control_initial <- list()
control_initial$regression <- list("R1" = c(0.13, 0.10, -0.20, -0.02, 0.037),
                                   "R2" = c(0.23, 0.01, -0.27, -0.11, 0.11))
control_initial$power <- list(c(0), c(0))
control_initial$tau <- c(0.15, 0, 0.12, rep(0,15))
fit_0 <- mglm4twin(linear_pred = c(form_Wt, form_Ht), matrix_pred = Z_biv0,
                   control_initial = control_initial,
                   control_algorithm = list(tuning = 0.5),
                   power_fixed = c(TRUE, TRUE), data = anthro)
}
\keyword{datasets}
