###################################################
### chunk number 1: "seed"
###################################################
set.seed(708983)
options(width=77)


###################################################
### chunk number 2: "library"
###################################################
library(aRT)
conn = openConn(name="root")
if(any(showDbs(conn)=="tabletest")) deleteDb(conn, "tabletest", force=T)
db = createDb(conn,db="tabletest")


###################################################
### chunk number 3: "spatialPointsDataFrame"
###################################################
quantity = 10
xc = round(runif(quantity),2)
yc = round(runif(quantity),2)

xy = cbind(xc,yc)
xy.sp = SpatialPoints(xy)
xy.spdf = SpatialPointsDataFrame(xy, data.frame(ID=paste(1:quantity)))


###################################################
### chunk number 4: "createStaticLayer"
###################################################
lstatic = createLayer(db, l="static")
addPoints(lstatic, xy.spdf)


###################################################
### chunk number 5: "createDataFrame"
###################################################
ID=getID(xy.spdf)
norm=unlist(lapply(ID, function(x) rnorm(1, 20,10)))
unif=unlist(lapply(ID, function(x) runif(1, 1,100)))

df = data.frame(ID, norm, unif)
df


###################################################
### chunk number 6: "createTable"
###################################################
tstatic = createTable(lstatic, "tstatic")
tstatic


###################################################
### chunk number 7: "updateColumns"
###################################################
updateColumns(tstatic, df)
tstatic


###################################################
### chunk number 8: "updateNewColumns"
###################################################
getData(tstatic)
df2 = data.frame(ID, norm=unlist(lapply(ID, function(x) rnorm(1, 20,10))), uniff=unif)
updateColumns(tstatic,df2)
getData(tstatic)


###################################################
### chunk number 9: "staticTableWithoutGen"
###################################################
tstatic2=createTable(lstatic, "tstatic2", gen=FALSE)
tstatic2


###################################################
### chunk number 10: "addRowsTwice"
###################################################
createColumn(tstatic2, "norm", type = "integer")
createColumn(tstatic2, "unif", type = "numeric")
addRows(tstatic2, df[1:5,])
getData(tstatic2)
addRows(tstatic2, df[6:10,])
getData(tstatic2)


###################################################
### chunk number 11: "addExistentRow"
###################################################
addRows(tstatic2, data.frame(ID="1",norm=2.1,unif=0.3))
getData(tstatic2)[1:3,]


###################################################
### chunk number 12: "createCharColumn
###################################################
createColumn(tstatic2, "charcol", type = "character", length=5)
tstatic2


###################################################
### chunk number 13: "createExternalTable"
###################################################
texternal=createTable(db, "texternal", ID="myid", length=5)
texternal


###################################################
### chunk number 14: "createMediaTable"
###################################################
mediatable=createTable(lstatic,type="media")


###################################################
### chunk number 15: "printMediaTable"
###################################################
mediatable


###################################################
### chunk number 16: "addMediaTableRows"
###################################################
ID=getID(xy.spdf)
url="http://www.est.ufpr.br/~pedro/media/media"

name=lapply(ID, function(x) sprintf("%s%s.html",url, x))
name=unlist(name)
df = data.frame(object_id=ID, media_name=name)
addRows(mediatable, df)


###################################################
### chunk number 17: "getMediaData"
###################################################
getData(mediatable)[1:5,]


###################################################
### chunk number 18: "printStaticLayer"
###################################################
lstatic


###################################################
### chunk number 19: "generateDates"
###################################################
toDate(year=2008,month=8,day=7,hour=6, sec=5)
ISOdate(year=2008,month=8,day=7,hour=6, sec=5)


###################################################
### chunk number 20: "copyLayer"
###################################################
lpoints = lstatic #createLayer(db, l="points")


###################################################
### chunk number 21: "createEventTable"
###################################################
tevent=createTable(lpoints, "events", type="event")
tevent


###################################################
### chunk number 22: "temporalDataFrame"
###################################################
ID=getID(xy.spdf)
hours = unlist(lapply(ID, function(x) round(runif(1,0,10),0)))

time=unlist(lapply(hours, function(x) toDate(y=2008, month=3, day=30, hour=x)))
#ftime=unlist(lapply(hours, function(x) toDate(y=2008, month=3, day=30, hour=x, minute=59)))

value=unlist(lapply(ID, function(x) runif(1, 1,100)))

df = data.frame(ID, value, time)
df[1:7,]


###################################################
### chunk number 23: "addEventRows"
###################################################
createColumn(tevent, "value", type="i")
addRows(tevent, df)
tevent


###################################################
### chunk number 24: "getEventData"
###################################################
getData(tevent)


###################################################
### chunk number 25: "createDynattTable"
###################################################
#tdynatt=createTable(lpoints, "dynatt", type="dynatt")
#tdynatt


###################################################
### chunk number 26: "createTheme"
###################################################
theme=createTheme(lpoints, "events", table="events")
theme
#getData(theme)[1:7,]


###################################################
### chunk number 27: "openQuerier"
###################################################
querier = openQuerier(theme, chronon="hour")
querier


###################################################
### chunk number 28: "slidesSumAlgorithm"
###################################################
qtde = summary(querier)$slides
#$
#qtde
#time=occourrences=total.value=NULL

#for(i in 1:qtde)
#{
#	value = nextSlide(querier)
#	if(value != 0){
#	  occourrences = c(occourrences, value)
#	  sum = 0
#	  for(j in 1:value)
#	  {
#	      data=getData(querier)
#	      sum = sum + as.integer(data$data$value)
#	  }
#	  time=c(time, data$data$itime)
#	  total.value = c(total.value, sum)
#	}
#}
#time
#occourrences
#total.value
#data.frame(time, occourrences, total.value)


