###################################################
### chunk number 1: "Loading package"
###################################################
library(aRT)


###################################################
### chunk number 2: "Loading package"
###################################################
aRTsilent(FALSE)


###################################################
### chunk number 3: "Creating a DBMS connection"
###################################################
con <- openConn(name="root")
con


###################################################
### chunk number 4: "Adding user"
###################################################
addPermission(con, "pedro")


###################################################
### chunk number 5: "Showing databases"
###################################################
showDbs(con)
if( any(showDbs(con) =="bodmin") ) deleteDb(con, "bodmin", 
  force=TRUE)


###################################################
### chunk number 6: "Creating new database"
###################################################
db <- createDb(con, db="bodmin")
db


###################################################
### chunk number 7: "Creating a new layer"
###################################################
layer.points <- createLayer(db, "points")
layer.points


###################################################
### chunk number 8: "Splancs"
###################################################
require(splancs)
data(bodmin)
names(bodmin)
bodmin$poly = bodmin$poly[-1,]


###################################################
### chunk number 9: "Adding points"
###################################################
SPoints = SpatialPointsDataFrame(cbind(bodmin$x, bodmin$y),
  data.frame(ID=paste(1:length(bodmin$x))))
addPoints(layer.points, SPoints)
t = createTable(layer.points, "tpoints")
layer.points


###################################################
### chunk number 10: "Adding polygons"
###################################################
p = Polygon(bodmin$poly)
P = Polygons(list(p), ID="1")
SP = SpatialPolygons(list(P))
layer.pol <- createLayer(db, l="polygons")
addPolygons(layer.pol, SP)
t = createTable(layer.pol, "tpol")


###################################################
### chunk number 11: "Adding raster"
###################################################
raster <- kernel2d(as.points(bodmin), bodmin$poly, h0=2, 
  nx=100, ny=200)

## converting the kernel to "sp"
g <- cbind(expand.grid(x = raster$x, y = raster$y), as.vector(raster$z))
coordinates(g) <- c("x", "y")
gridded(g) <- TRUE
fullgrid(g)=TRUE

layer.raster <- createLayer(db, l="raster")
addRaster(layer.raster, g)


###################################################
### chunk number 12: "Show layers"
###################################################
showLayers(db)
db


###################################################
### chunk number 13: plotPoints eval=FALSE
###################################################
## plot(layer.raster)
## plot(layer.points,add=TRUE)
## pols = getPolygons(layer.pol)
## plot(pols, add=TRUE)


###################################################
### chunk number 14: 
###################################################
plot(layer.raster)
plot(layer.points,add=TRUE)
pols = getPolygons(layer.pol)
plot(pols, add=TRUE)


###################################################
### chunk number 15: Themes
###################################################
theme.points<-createTheme(layer.points, "points", view="view")
setVisual(theme.points, visualPoints(size=5))
theme.pol<-createTheme(layer.pol, "polygons", view="view")
setVisual(theme.pol, visualPolygons())


###################################################
### chunk number 16: ThemeRaster
###################################################
theme.raster<-createTheme(layer.raster, "raster", v="view")
setVisual(theme.raster, visualRaster(col = terrain.colors(20)), mode="raster")


