# Exemplo de relacoes espaciais utilizando os
# trs tipos de geometria.
# Este exemplo utiliza os dados de Recife

require(aRT)

con = openConn()
con

if(any(showDbs(con)=="recife"))
  deleteDb(con, "recife", force=T)

db = createDb(con, "recife")

lbairros    = createLayer(db, "bairros")
larmadilhas = createLayer(db, "armadilhas")
ldrenagem   = createLayer(db, "drenagem")

data(recife.districts)
data(recife.points)
data(recife.sewers)

addPolygons(lbairros,    recife.districts)
addPoints  (larmadilhas, recife.points)
addLines   (ldrenagem,   recife.sewers)

tbairros    = createTable(lbairros,   "t_bairros")
tarmadilhas = createTable(larmadilhas,"t_armadilhas")
tdrenagem   = createTable(ldrenagem,  "t_drenagem")

# remover os objetos do R e cria-los novamente para
# provar que eles esto realmente no banco
rm(con)
rm(db)
invisible(gc())

con <- openConn()
bdrecife <- openDb(con, "recife")
showLayers(bdrecife)

lbairros    = openLayer(bdrecife, "bairros")
larmadilhas = openLayer(bdrecife, "armadilhas")
ldrenagem   = openLayer(bdrecife, "drenagem")

geobairros    = getPolygons(lbairros)
geoarmadilhas = getPoints(larmadilhas)
geodrenagem   = getLines(ldrenagem)

par(mfcol=c(2,2), mar=c(.5,.5,.5,.5))

# plotando bairros e armadilhas
aRTplot(geobairros, col="red")
aRTplot(geoarmadilhas, add=T)

# plotando rede de drenagem da cidade
aRTplot(geobairros, col="gray", lty=0)
aRTplot(geodrenagem, col="blue", add=T)

## Relacoes espaciais
# 1. todos os bairros que Contem armadilhas
getRelation(lbairros, "contains", larmadilhas)->rel1
rel1

# 2. todos os vizinhos (touch) dos bairros que possuem armadilhas
getRelation(lbairros, "touch", id=rel1)->rel2

aRTplot(geobairros, col="gray", lty=0)
aRTplot(geobairros, col="green", id=rel2, add=T)
aRTplot(geobairros, col="yellow", id=rel1, add=T)
# nao desenhei as armadilhas porque senao nao d pra ver os bairros (fica preto)
# plot(geoarmadilhas, add=T)

# 3. drenagens que cruzam os bairros que tem armadilhas
getRelation(ldrenagem, "crosses", layer=lbairros, id=rel1)->rel3

# 4. drenagens que estao contidas (within) nos bairros que tem armadilhas
getRelation(ldrenagem, "within", layer=lbairros, id=rel1)->rel4

aRTplot(geobairros, col="gray", lty=0, id=rel1)
aRTplot(geobairros, col="gray", lty=0, add=T)
aRTplot(geobairros, col="yellow", lty=0, add=T, id=rel1)

aRTplot(geodrenagem, add=T)
aRTplot(geodrenagem, col="green", id=rel3, add=T)
aRTplot(geodrenagem, col="red", id=rel4, add=T)

# gerando temas com as mesmas imagens vistas no R
th1 = createTheme(lbairros,    "bairros1",    view="bairros")
th2 = createTheme(larmadilhas, "armadilhas1", view="bairros")

setVisual(th1, visualPolygons(color="red", transp=0))
setVisual(th2, visualPoints(pch=22))

th3 = createTheme(lbairros,  "bairros2",  view="drenagem")
th4 = createTheme(ldrenagem, "drenagem2", view="drenagem")

setVisual(th3, visualPolygons(color="gray", ccolor="gray", transp=0))
setVisual(th4, visualLines(color="blue"))

th5 = createTheme(lbairros, "vizinhos3", view="vizinhos", id=unique(rel2))
th6 = createTheme(lbairros, "contem3",   view="vizinhos", id=unique(rel1))
th7 = createTheme(lbairros, "todos3",    view="vizinhos")

setVisual(th5, visualPolygons(color="green", transp=0))
setVisual(th6, visualPolygons(color="yellow", transp=0))
setVisual(th7, visualPolygons(color="gray", ccolor="gray", transp=0))

th8  = createTheme(ldrenagem, "cruzam4",   view="final", id=unique(rel3))
th9  = createTheme(ldrenagem, "contem4",   view="final", id=unique(rel4))
th10 = createTheme(lbairros,  "vizinhos4", view="final", id=unique(rel1))
th11 = createTheme(ldrenagem, "drenagem4", view="final")
th12 = createTheme(lbairros,  "bairros4",  view="final")

setVisual(th8, visualLines(color="blue"))
setVisual(th9, visualLines(color="red"))
setVisual(th10, visualPolygons(color="yellow", ccolor="yellow", transp=0))
setVisual(th11, visualLines(color="black"))
setVisual(th12, visualPolygons(color="gray", ccolor="gray", transp=0))

par(mfrow=c(1,1))

# ver e chacar visiualizacoes no TV

