# Exemplo de realizao de mtricas de conjunto
# utiliza o conjunto de dados catarina

require(aRT)
data(pol3)

plot(pol3)

con <- openConn()
showDbs(con)

if(any(showDbs(con)=="pol3"))
	deleteDb(con, "pol3", force=T)

db <- createDb(con, "pol3")

l_pol <- createLayer(db, "poligonos")
addPolygons(l_pol, pol3)
t_pol <- createTable(l_pol,"table_pol")


par(mfcol=c(2,4), mar=c(.3,.3,.3,.3))

plot(l_pol)

getOperation(l_pol, "buffer", d=5000)->buffer

plot(l_pol, col="gray", lty=0)
plot(l_pol, id=c("1"), add=T, col="green")
aRTplot(buffer, id=c("1"), add=T, border="red", lty=2)

plot(l_pol, col="gray", lty=0) 
plot(l_pol, id=c("2"), add=T, col="green")
aRTplot(buffer, id=c("2"), add=T, border="red", lty=2)

plot(l_pol, col="gray", lty=0) 
plot(l_pol, id=c("3"), add=T, col="green")
aRTplot(buffer, id=c("3"), add=T, border="red", lty=2)

# calculando a uniao e interseccao de alguns conjuntos
getSetOperation(l_pol, "union", id=c("2","1"))->datau
getSetOperation(l_pol, "inter", id=c("2","3"))->datai
getSetOperation(l_pol, "diff", id=c("2","3"))->datad
#getSetOperation(l_pol, "x", id=c("2","3"))->datax

# inserindo estes resultados em um novo layer e
# calculando as suas cascas convexas
l2<-createLayer(db, "ui")

datau@polygons[[1]]@ID = "1"
datai@polygons[[1]]@ID = "2"
data=SpatialPolygons(c(datau@polygons, datai@polygons), 1:2)

addPolygons(l2, data)

createTable(l2,"table_ui")

getOperation(l2, "hull")->hull2

# plotando o resultado das operacoes juntamente
# com as suas cascas convexas
plot(l_pol, col="gray", lty=0) 
aRTplot(datau, col="yellow", add=T)
aRTplot(hull2, id=c("2_1"), border="blue", add=T)

plot(l_pol, col="gray", lty=0) 
aRTplot(datai, col="orange", add=T)
aRTplot(hull2, id=c("2_3"), border="blue", add=T)

plot(l_pol, col="gray", lty=0) 
aRTplot(datad, col="orange", add=T)

plot(l_pol, col="gray", lty=0) 
#aRTplot(datax, col="orange", add=T)
