# Exemplo de como criar um banco de dados
# no aRT, a partir do conjunto de dados
# parana, do pacote geoR

##
## Carregando pacotes/funcoes
##
require(geoR)
require(aRT)

##
## Exemplo 1: dados parana
##
data(parana)
points(parana, bor=borders)

## criando uma conexao com o SGBD (MySQL)
con <- openConn()
showDbs(con)
con
## opcoes para: host, port, user, password

if(any(showDbs(con)=="parana")) deleteDb(con, "parana", force=T)

## criando um novo BD
con
pr <- createDb(con, "parana")

##
## 1.1 criando um layer para armazenar os dados
##
l_dados <- createLayer(pr, "dados")
l_dados

## carregando geometrias (pontos)
Points = SpatialPoints(parana$coords)
PointsDF = SpatialPointsDataFrame(Points, data.frame(ID=paste(1:143)))
PointsDF[1:3,]


addPoints(l_dados, PointsDF)
t_dados = createTable(l_dados, "t_dados",gen=T)

t_dados
plot(l_dados)

# inserindo atributos (so depois de fechar geometria)
artdata <- data.frame(id=paste(1:143), data=parana$data)

length(parana$data)

artdata[1:5,]

names(artdata)
createColumn(t_dados, "data")
updateColumns(t_dados, artdata)


t_dados
## criando vistas e temas automaticas para o TV (opcional)
tema_dados <- createTheme(l_dados, "estacoes", view = "view")
setVisual(tema_dados, visualPoints(pch=22, color="black", size=5))

##
## 1.2 criando um layer para armazenar o contorno do estado
##

artpols <- SpatialPolygons(list(Polygons(list(Polygon(parana$borders)),"1")),1)

l_pol<-createLayer(pr, "contorno")
addPolygons(l_pol, artpols)
createTable(l_pol, "t_pol")
plot(l_pol)

tema_pol<-createTheme(l_pol, "contorno", view="view")
setVisual(tema_pol, visualPolygons())

#
# Executando um algoritmo para anlise espacial (krigagem)
#
ml <- likfit(parana, trend="1st", ini=c(1000, 100))
gx <- seq(50,800, by=10)
gy <- seq(-100,650, by=10)
loc0 <- expand.grid(gx,gy)
points(parana, bor=borders)
points(loc0, pch=".", col=2)
loc1 <- polygrid(loc0, bor=parana$bor)
points(loc1, pch="+", col=4)

KC <- krige.control(trend.d="1st", trend.l="1st", obj=ml)
kc <- krige.conv(parana, loc=loc0, krige= KC, bor=parana$borders)
save.image()

image(kc, col=terrain.colors(15))

# preparando objeto para aRT
georpred <- .prepare.graph.kriging(locations=loc0, borders=parana$borders, values=kc$pred)
names(georpred)[3] <- "z"

l_pred <- new("aRTlayer", pr, layer="pred", create=T)

addRaster(l_pred, georpred)

# se o nome do tema for omitido, o seu nome sera o mesmo do layer
th<-createTheme(l_pred, "raster", view="view")

setVisual(th, visualRaster(), mode="r")

th3=createTheme(l_dados,"maiores", att="data > 300", view="select")

par(mfcol=c(1,2), mar=c(.5,.5,.5,.5))

plot(l_pred, col=terrain.colors(15))
plot(l_dados, add=T)
plot(l_pol, add=T)

getData(th3)->data
aRTplot(data)
plot(l_pred, col=terrain.colors(15),add=T)
plot(l_pol,add=T)
plot(l_dados,add=T)
aRTplot(data,add=T,pch=19)



