# Exemplo de calculo de metricas espaciais
# utilizando o conjunto de dados catarina

require(aRT)
con<-openConn()
con
if(any(showDbs(con)=="catarina"))
  deleteDb(con, "catarina", force=T)

db<-createDb(con,"catarina")

data(catarina)

lcities = createLayer(db, "cities")
addPolygons(lcities, catarina)
t = createTable(lcities, "cities")

hull = getOperation(lcities, "hull")
center = getOperation(lcities, "centroid")
area = getMetric(lcities, "area")

# polgonos cuja area for maior que 1.100.000.000
ids = area$id[which(area$area > 1.1*10^9)]

# construindo area de plotagem 2x2
par(mfcol=c(2,2), mar=c(.5,.5,.5,.5))

# plota os municipios do estado
aRTplot(catarina, col="red")

# plotagem com o buffer dos maiores municipios
aRTplot(catarina, id=ids)
aRTplot(catarina, col="gray", bor="white", add=T)
aRTplot(hull, id=ids,  col="green", add=T)
aRTplot(catarina, id=ids, col="gray", add=T)

center = getOperation(lcities, "centroid")
lcenter = createLayer(db, "center")
addPoints(lcenter, center)
t = createTable(lcenter,"center")

oesteids = getID(center[which(coordinates(center)[,1] < 193472),])

# alguns poligonos escolhidos a dedo
id=c("67","241","290","101","76")
buffer = getOperation(lcities, "buffer", dist=3500, id=id)

# plota o buffer dos poligonos escolhidos
aRTplot(catarina, id=oesteids, col="gray")
aRTplot(catarina, bor="white",col="gray", add=T)
aRTplot(catarina, id=oesteids, bor="white", col="gray", add=T)
aRTplot(buffer, col="yellow", add=T)
aRTplot(catarina, id=id, add=T, col="gray")

# funcao para desenhar os vizinhos mais proximos de 
# um layer de pontos dado uma distancia maxima
drawNearest = function(distance)
{
	aRTsilent(TRUE)
	aRTplot(catarina, id=oesteids, bor="white", col="gray")
	aRTplot(catarina, bor="gray", add=T) 
	aRTplot(catarina, id=oesteids, bor="white", col="gray", add=T)

	aRTplot(center, add=T, id=oesteids)
	id = oesteids 

	# cria um SpatialLines com uma linhe, depois s
	# muda esta  linha e plota
	l=Line(points[c(1,2),]@coords)
	L = Lines(l, paste(1,2, sep="_"))
	SL=SpatialLines(list(L))

	# para cada par de pontos calcula a distancia e plota
	# se for menor que o limiar
	for(i in 1:(length(id)-1))
	{
      for(j in (i+1):(length(id)))
	  {
		d = getDistance(lcities, paste(c(id[i],id[j])))
		if(d < distance)
		{
		  SL@lines[[1]]@Lines[[1]]@coords=points[c(i,j),]@coords
		  aRTplot(SL, add=T, col="blue")
		}
	  }
	}
	aRTsilent(FALSE)
}

#drawNearest(15000)

#drawNearest(lcenter, loeste, 13000)
#drawNearest(lcenter, loeste, 14000)
#drawNearest(lcenter, loeste, 15000)
#drawNearest(lcenter, loeste, 16000)

