require(sp)
require(spdep)
require(aRT)

data(auckland)

res <- probmap(auckland$Deaths.1977.85, 9*auckland$Under.5.1981)

#brks = c(-Inf, 2, 2.5, 3, 3.5, Inf)
#cols = 1:5
#rawx=cols[findInterval(res$raw*1000, brks)]

res2 = cbind(auckland, res)
res2 = cbind(data.frame(id = paste(1:length(auckpolys)), res2))

#rawx = as.numeric(rawx)
#res2 = cbind(res2, data.frame(rawx))

polygons=list()

for(i in 1:length(auckpolys))
{
	p = Polygon(auckpolys[[i]])
	P = Polygons(list(p), ID = paste(i))
	polygons[[i]]=P
}

SpatialPolygons(polygons)->SP

con = openConn()
if(any(showDbs(con) == "auck")) deleteDb(con, "auck", force=T)
db=createDb(con, "auck")

l = createLayer(db, "auck")
addPolygons(l, SP)
t = createTable(l, "t_auck", gen=T)

updateColumns(t, res2)

th=createTheme(l, "auck-raw")

res2[1:3,]

v1=visualPolygons(color= c("#F7F7F7", "#CCCCCC", "#969696", "#636363", "#252525"), transp=0)
setVisual(th, v1, att="raw")

th=createTheme(l, "auck-relRisk")
setVisual(th, v1, att="relRisk")

th=createTheme(l, "auck-pmap")
setVisual(th, v1, att="pmap")

th=createTheme(l, "auck-expCount")
setVisual(th, v1, att="expCount")
