/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#include <iostream>
#include "aRTcomponent.h"

using namespace std;

bool aRTcomponent::Silent = false;

aRTcomponentLeaf::aRTcomponentLeaf() : aRTcomponent()
{
	Parent = NULL;
	Valid  = true;
}

void aRTcomponentLeaf::Clear()
{
	if(Parent && Valid) Parent->RemoveChild(this); // Valid: 3 hours of headache
	SetInvalid();
}

void aRTcomponentRoot::RemoveChild(aRTcomponentLeaf* child)
{
    list<aRTcomponentLeaf*>::iterator it;

	for(it = Children.begin(); *it != child; it++);

	Children.erase(it);
}

void aRTcomponentRoot::AddChild(aRTcomponentLeaf* child)
{
    child->Parent = this;
    Children.push_back(child);
}

void aRTcomponentLeaf::SetInvalid()
{
    Valid = false;
}

void aRTcomponentRoot::Clear()
{
	list<aRTcomponentLeaf*>::iterator it = Children.begin();
	
	while(it != Children.end())
	{
		(*it)->SetInvalid();
		it++;
	}	
}

