/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#include "SEXPbasic.h"

#include <iostream>
#include <sstream>

using namespace std;

extern "C"{

SEXP GetListElement(SEXP list, char *str) {
  SEXP names;
  SEXP elmt = (SEXP) NULL;
  char* tempStr;

  PROTECT(names = getAttrib(list, R_NamesSymbol));
  for (int i = 0; i <= Rf_length(names)-1; i++) {
    tempStr = CHAR(STRING_ELT(names, i));
    if (strcmp(tempStr, str) == 0) {
      elmt = VECTOR_ELT(list, i);
      break;
    }
  } 
  UNPROTECT(1);
  return elmt;
}

SEXP AsDataFrame(SEXP list, SEXP rownames)
{
	SEXP classname = allocVector(STRSXP, 1);
	SET_STRING_ELT( classname, 0, mkChar("data.frame") );
	
	SET_CLASS(list, classname);
	setAttrib(list, R_RowNamesSymbol, rownames);

	return list;
}

SEXP Resize(SEXP value, int newlength)
{
	value = Rf_lengthgets(value, newlength);
	UNPROTECT(1);
	PROTECT(value);
	return value;
}

SEXP CharToSEXP(char* vchar)
{
	SEXP value = allocVector(STRSXP, 1);         
    SET_STRING_ELT(value, 0, mkChar(vchar));
	return value;
}

SEXP getObjHandle(SEXP obj)
{
    SEXP sxpHandle = getAttrib( obj, mkString("pointer") );
    if( isNull(sxpHandle) ) error("Object is NULL");
    return sxpHandle;
}

void* getObj(SEXP sxpHandle)
{
    void* pointer = R_ExternalPtrAddr(sxpHandle);
    if(!pointer) error("External pointer is NULL");
    return pointer;
}

int GetPos(SEXP names, char* value_)
{
	string value = value_;
	for(int i = 0; i < LENGTH(names);i++)
	{
		if(value == CHAR(STRING_ELT(names, i)))
			return i;
	}
	return -1;
}

char* GetStringItemPos(SEXP value, int pos)
{
	stringstream s;
	switch( TYPEOF(value) )
   	{
		case REALSXP: s << REAL(value)[pos];            break;
       	case INTSXP:  s << INTEGER(value)[pos];         break;
       	case STRSXP:  s << CHAR(STRING_ELT(value,pos)); break;
        default: cerr << "IDs type unrecognized" << endl;
	}
	return (char*)(s.str().c_str());//StreamToChar(s);//string str = s.str();
//	return (str.c_str();
}

char* GetStringFactorPos(SEXP factor, int pos) 
{                                                   
	int factorvalue = INTEGER(factor)[pos] - 1; // reference here starts with 1. 
	SEXP attrib = getAttrib(factor,R_LevelsSymbol); 
    return CHAR(STRING_ELT(attrib,factorvalue));
}

/*
void printAttrib(SEXP e)
{
	SEXP rn=Rf_GetRowNames(e);
	if(rn != R_NilValue)
	{
		printf("Row names:\n");
		printSEXP(rn);
	}

	SEXP cn=getAttrib(e, R_NamesSymbol);
	{
		printf("Col names:\n");
		printSEXP(cn);
	}
}*/

void printSEXP(SEXP e)
{
    int i = 0;

    switch( TYPEOF(e) )
    {
        case NILSXP:
            printf("NULL value\n");
            return;

        case LANGSXP:
            printf("language construct\n");
            return;

        case REALSXP:
            if (LENGTH(e) > 1)
            {
                printf("Vector of real variables: ");
                while( i < LENGTH(e) )
                {
                    printf("%f",REAL(e)[i]);
                    if ( !(REAL(e)[i] < 0) && !(REAL(e)[i] >= 0) ) printf("__NAN__");
                    if (i < LENGTH(e) - 1) printf(", ");
                    if (dumpLimit && i > dumpLimit) { printf("..."); break; }
                    i++;
                }
                putchar('\n');
            }
            else printf( "Real variable %f\n", *REAL(e) );
            return;
        case EXPRSXP:
            printf( "Vector of %d expressions:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit){ printf("...");  break; }
                printSEXP( VECTOR_ELT(e,i) );
                i++;
            }
            return;

         case INTSXP:
            printf( "Vector of %d integers:\n", LENGTH(e) );

            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit) { printf("..."); break; }
                printf("%d",INTEGER(e)[i]);
                if (i < LENGTH(e) - 1) printf(", ");
                i++;
            };
            putchar('\n');
            return;

        case VECSXP:
            printf( "Vector of %d fields:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i>dumpLimit) { printf("..."); break; };
                printSEXP(VECTOR_ELT(e,i));
                i++;
            }
            return;

        case STRSXP:
            printf( "String vector of length %d:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit) { printf("..."); break; };
                printSEXP(VECTOR_ELT(e,i)); i++;
            }
            return;
	   case CHARSXP:
            printf( "scalar string: \"%s\"\n",(char*) STRING_PTR(e) );
            return;

        case SYMSXP:
            printf( "Symbol, name: "); printSEXP(PRINTNAME(e) );
            return;

        default:
            printf( "Unknown type: %d\n", TYPEOF(e) );
    }
};

}

