\name{aRTtheme}

\docType{class}

\alias{aRTtheme-class}
\alias{aRTtheme}
\alias{initialize,aRTtheme-method}
\alias{plot,aRTtheme-method}

\title{Class aRTtheme}
\description{Class that enables database queries with temporal and (or) attributes
restrictions. It can be created using the results of a spatial query, passing the
ids. Temporal queries are executed creating an \code{aRTquerier} object from this object.

Themes in TerraLib can have visual aspects, as colors and lines styles. These
configurations are not used when an \code{aRTtheme} object is created, besause it
can be used only for processing. But there are functions to do this, for example
\code{setVisual} and \code{setVisible}.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTtheme", aRTlayer, themename)}.
To avoid creating objects this way, there are two functions of class \code{aRTlayer}:
\code{createTheme} and \code{openTheme}. \code{openTheme} is a function of class
\code{aRTdb} too.
}

\section{Arguments}{
  \describe{
  \item{layer}{The layer where the theme is associated. Object of class \code{aRTlayer}.}
  \item{themename}{The theme name. The default value is the layer name.}
  \item{create}{Creates a new theme when \code{TRUE}, and open a existing theme when \code{FALSE}.
  The default is \code{FALSE}.}
  \item{tables}{The table(s) of the used layer.}
  \item{viewname}{The view name. The default is the theme name.}
  }
}

\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
    \item{getBox}{Returns the bounding box.}
    \item{getData}{Returns all attributes and geometry of a layer.}
	\item{setVisible}{Changes the visibility of a theme (visible or not).}
    \item{setVisual}{Sets the colors associated to a theme's geometry.}
  }
}

\author{Marcos Aurelio Carrero, Pedro Ribeiro de Andrade Neto}
\keyword{classes}
\seealso{
 See \code{aRTtheme-METHOD} for a method of this class or \code{CLASSNAME-class} for links to other classes.
}
% vim: syntax=tex
