\name{aRTtable}
\docType{class}
\alias{aRTtable}
\alias{aRTtable-class}
\alias{initialize,aRTtable-method}

\title{Class aRTtable}
\description{Class that represents a DBMS table. It can be one of the various TerraLib
table types.

Tables are created from layers, and their attributes can be linked to other tables or
geometries. For selecting data joining tables with the links use aRTthemes.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTtable", aRTlayer, tablename, create = T)}
}

\section{Arguments}{
   \describe{
   \item{parent:}{Object of class \{\code{aRTlayer},\code{aRTdb}\}.}
   \item{tablename:}{Name of the table.}
   \item{create:}{Can the table be created if it does not exist?}
   \item{id:}{The name of the unique identifier of the table (default = \dQuote{id}).
         Used only at creating.}
   \item{length:}{The maximum length of id instances. Used only at creating.}
   \item{generateids:}{Populate the table ids linking with the layer geometries?
         Used only at creating, and with static and dynamic attributes tables only.}
   \item{type:}{The type of the table, see below.}
  }
}

\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
	\item{updateColumns:}{Add new columns and(or) update them.}
	\item{addRows:}{Add new elements to the table.}
	\item{getData:}{Returns the table values.}
  }
}

\section{Table types}{
In TerraLib there are several types of table, implementing the entity relationship,
temporal and other models. They are:
\describe{
\item{static}{Table which each geomety has one, and only one, respective row.}
\item{media}{A media table has only two columns: object\_id and media\_name. 
      It associates an url to a geometry double-click in a TerraLib-based GIS.
      A layer can have only one media table, and this table does not have a name.}
\item{external}{Each row is not implicitly connected to a geometry, but
      the table can have foreign keys to all static, event and dynamoc tables.}
\item{event}{One geometry occours in a specific time interval, as murderers.}
\item{dynatt}{Attributes changing in the time, but the objects have static geometry.}
\item{alldyn}{Fully dynamic (attributes and geometry). (not implemented yet)}
\item{dyngeom}{Dynamic Geometry. (not implemented yet)}
\item{default}{The default value depending on the parent. If the class is aRTlayer,
      default will be static, else (aRTdb) it will be external.}
}
}

\author{Pedro Ribeiro de Andrade Neto}
\keyword{classes}
\keyword{chron}
\seealso{
 See \code{aRTtable-METHOD} for a method of this class or \code{CLASSNAME-class} for links to other classes.
}

% vim: syntax=tex
