\name{aRTquerier}
\docType{class}
\alias{aRTquerier-class}
\alias{initialize,aRTquerier-method}

\title{Class aRTquerier}

\description{Class that manipulates the result of a query in a database.
It returns the objects one by one, and can slide a temporal aRTtheme.
This class is different from the others because it does not store anything in the
database.}

\section{Objects from the Class}{
\code{obj = new("aRTquerier", parent,... )}
Objects can be created by calls of the form \code{openQuerier(parent, loadgeom=T, loadatt=T)},
or \code{openQuerier(theme, chronon="hourofday")}.
}

\section{Arguments}{
   \describe{
   \item{parent:}{Object of class \{\code{aRTlayer},\code{aRTtheme}\}}
   \item{loadgeom:}{Will geometry be retrieved?}
   \item{loadatt:}{Will attributes be retrieved?}
   \item{chronon:}{A temporal slicing.}
   \item{table:}{(not implemented)}
   \item{att:}{(not implemented)}
   \item{stat:}{(not implemented)}
   }
}

\section{Chronon}{
    \itemize{
    \item nochronon
    \item second
	\item minute
	\item hour
	\item day
	\item month
	\item year
	\item dayofweek
	\item dayofmonth
	\item dayofyear
	\item monthofyear
	\item season
	\item weekofyear
	\item hourofday
	\item minuteofhour
	\item secondofminute
	}
}

\section{Stat}{
	\itemize{
	\item nostat
	\item sum
	\item max
	\item min
	\item count
	\item validcount
	\item stddev
	\item kernek
	\item mean
	\item variance
	\item skewness
	\item kurtosis
	\item median
	\item varcoeff
	\item mode
  }
}

\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
    \item{getData:}{Returns the next element of the query result in the actual slide.}
	\item{nextSlide:}{Loads the next slide, if there is a temporal sliding. A temporal
	query needs to load one slide before using \code{getData} for getting its elements.
	Non-temporal queries can't use this function. Note that you can do a non-temporal
	query in a temporal layer.}
  }
}

\author{Pedro Ribeiro de Andrade Neto}

\keyword{classes}
\keyword{chron}

% vim: syntax=tex
