\name{aRTlayer-getOperation}

\docType{object}

\alias{getOperation,aRTlayer-method}
\alias{getOperation}
\alias{hull}
\alias{center}
\alias{centroid}

\usage{
\S4method{getOperation}{aRTlayer}(object, operation, distance)
}

\title{getOperation}

\description{Returns some spatial operation that is not stored in the layer.
It returns the result of this operation over each element.}

\arguments{
  \item{object}{Object of class \code{aRTlayer}.}
  \item{operation}{One of:
   \itemize{
	  \item centroid
	  \item hull
	  \item buffer
   }
  }	
  \item{distance}{The distance, used only with buffer.}
}

\examples{
\dontrun{
getOperation(layer, "hull")
getOperation(layer, "buffer", dist=500)
}}

\author{Pedro Ribeiro de Andrade Neto}
\keyword{connection}

\seealso{
   See \code{aRTlayer-class} to the description of this class.
}

% vim: syntax=tex
