\name{aRTlayer}

\docType{class}

\alias{aRTlayer}
\alias{aRTlayer-class}
\alias{initialize,aRTlayer-method}
\alias{plot,aRTlayer-method}

\title{Class aRTlayer}
\description{Class that represents a layer of information in the database. It can insert
geometries into the database, process them and create/open \code{aRTtable}, \code{aRTtheme} 
and \code{aRTquerier} objects.
TerraLib layers can stores various geometries in a layer, but in aRT, for simplify,
each layer stores only one type of geometry.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTlayer", aRTdb, layername, proj)}.
Examples:\cr
   \code{obj = new("aRTlayer", aRTdb, layername, create=T)}\cr
   \code{obj = new("aRTlayer",db,l="llatlong",proj="+proj=latlong +datum=NAD83",c=T)}\cr

To avoid creating objects this way, there are two functions of class \code{aRTdb}:
\code{createLayer} and \code{openLayer}.
}

\section{Arguments}{
   \describe{
   \item{aRTdb}{Object of aRTdb class.}
   \item{layername}{Name of the layer.}
   \item{proj}{Projection in proj.4 format. Some projections are not supported by TerraLib.}
   \item{create}{Can the layer be created if it does not exist?}
   }
}
				 
\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
    \item{addLines:}{Insert lines in the layer.}
    \item{addPoints:}{Insert points in the layer.}
    \item{addPolygons:}{Insert polygons (rings) in the layer.}
	\item{createTheme:}{Create a new theme and returns it.}
	\item{getAttributes:}{Return the stored attributes.}
	\item{getPoints:}{Return the points of the layer.}
	\item{getLines:}{Return the lines of the layer.}
	\item{getPolygons:}{Return the polygons of the layer.}
	\item{getMetric:}{Return a metric operations (buffer, length, area, convex hull).}
	\item{getNN:}{Nearest Neighbors (not implemented yet).}
	\item{getRelation:}{Look for spatial relations as contains, crosses, touches.}
	\item{getSetMetric:}{Calculate a set operation (union, difference, intersection, xor).}
 	\item{openTheme:}{Open an existent theme.}
	\item{plot:}{Plots the data.}
    \item{showTables:}{Show all information tables in the layer.}
 }
}

\author{Marcos Aurelio Carrero, Pedro Ribeiro de Andrade Neto}
\keyword{classes}
\seealso{
 See \code{aRTlayer-METHOD} for a method of this class or \code{CLASSNAME-class} for links to other classes.
 Package \pkg{spproj} for conversion of projections.
}

% vim: syntax=tex
