\docType{object}

\alias{createTable}
\alias{createTable,aRTlayer-method}
\alias{createTable,aRTdb-method}
\alias{createTable}

\title{Create an attribute table}
\name{aRTdb-createTable}

\description{Creates a new attribute table in the database and returns it.
It the table is created from an \code{aRTdb} its type will be external, when 
creating from layers it can be any type (but external).
}

\details{TerraLib uses some tables in the database, and then you cannot create
tables with these names. Names as \dQuote{\code{Points...}}, \dQuote{\code{Polygons...}},
(other geometries), \dQuote{\code{tempTable}} and \dQuote{\code{te_...}} are reserved.
Note that names with non letters characters are also prohibited.
}

\usage{
\S4method{createTable}{aRTdb}(object, tablename, id, length)
\S4method{createTable}{aRTlayer}(object, id, length, generateids=F, type="event")
}

\arguments{
   \item{object}{Object of aRTlayer or aRTdb class.}
   \item{tablename}{Name of the table.}
   \item{id}{The name of the unique identifier of the table (default = "id").}
   \item{length}{The maximum length of id instances.}
   \item{generateids}{Populate the table ids linking with the layer geometries?
         Used with static and dynamic attributes tables only (default = TRUE).}
   \item{type}{The type of the table. See \code{\link{aRTtable-class}} for the
         available types.}
}

\author{Pedro Ribeiro de Andrade Neto}
\keyword{database}
\seealso{
  See \code{\link{aRTtable-class}} to the description of table types.
}
% vim: syntax=tex
