\name{aRTdb}
\docType{class}
\alias{aRTdb-class}
\alias{aRTdb}
\alias{initialize,aRTdb-method}

\title{Class aRTdb}

\description{Class that manipulates a database. Data is stored in layers (geometries and
their attributes) or external tables (attributes not directly connected with geometries).
\code{aRTdb} objects consume more memory then any other object of this package, because
it stores all themes, layers and table definitions, and these objects store just a
pointer to its \dQuote{father}. We recommend to work with only one object of this class
per time.
}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTdb", aRTconn, dbname, create)}.
To avoid creating objects this way, there are two functions of class \code{aRTconn}:
\code{createDb} and \code{openDb}.
}

\section{Arguments}{
  \describe{
  \item{aRTconn}{Object of aRTconn class.}
  \item{dbname}{Database name.}
  \item{create}{Create a new database when create=TRUE, and open a existing database
       when create=FALSE. The default is create=FALSE.}
  }
}
		  
\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
	\item{createLayer:}{Creates a new layer returns it.}
    \item{createView:}{Creates an empty View in the database.}
    \item{deleteLayer:}{Delete a layer in the database.}
    \item{deleteTheme:}{Delete a theme in the database.}
    \item{deleteView:}{Delete a view in the database.}
    \item{importShape:}{Imports a shapefile to the database.}
 	\item{openLayer:}{Opens an existent layer.}
 	\item{openTheme:}{Opens an existent theme. (Themes can be created only from layers.)}
    \item{showLayers:}{Shows all the available layers.}
    \item{showThemes:}{Shows all the available themes.}
    \item{showViews:}{Show all the available views.}
	\item{summary:}{Some information about the database.}
  }
}

% TODO: aqui por enquanto
\alias{aRTloadEnv}
\alias{aRTsaveEnv}
\alias{aRTremoveEnv}
\alias{aRTclearEnv}
\alias{aRTgetEnv}


\section{Environments}{
An \code{aRTenv} is the set of themes and views of a user in a TerraLib database.
Layers in a database are visible by all users that have read permission in the
database, but each user has it owns views and themes. Therefore it can be useful
to manipulate a user's environment, as for example save in a file, load and
remove.

\code{aRTloadEnv}, \code{aRTsaveEnv}, \code{aRTclearEnv}, \code{aRTgetEnv} 
and \code{aRTremoveEnv} manipulate environments
without any aRT object as argument.

Views are only destinate to TerraView users. It has no importance inside R.
}

\author{Marcos Aurelio Carrero, Pedro Ribeiro de Andrade Neto}

\keyword{classes}
\seealso{
 See \code{aRTdb-METHOD} for a method of this class or
     \code{CLASSNAME-class} for links to other classes.
}

% vim: syntax=tex
