\name{aRTconn}

\docType{class}

\alias{aRTconn-class}
\alias{initialize,aRTconn-method}
\alias{aRTconn}
\alias{openConn}

\title{Class aRTconn}
\description{Class that stores a virtual DBMA connection and manipulates databases.
The connection is virtual because each time a function is called, it connects, does
something and then disconnects.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{openConn(user, password, port, host)}.
}

\section{Arguments}{
  \describe{
  \item{user}{User of the DBMA. The default is the user logged in the system.}
  \item{password}{The password, default is \dQuote{}.}
  \item{port}{Port of the connection,  default value is 3306.}
  \item{host}{Host to connect, default is \dQuote{localhost}.}
  }
}

\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
	\item{addUser:}{Grants ALL permissions on the DBMS to a user.}
	\item{createDb:}{Creates a new database and returns a connection to it.}
	\item{deleteDb:}{Removes a database from the DBMS.}
	\item{openDb:}{Opens an existent database from the DBMS.}
    \item{showDbs:}{Shows the avilable databases.}
  }
}

\author{Marcos Aurelio Carrero, Pedro Ribeiro de Andrade Neto}

\seealso{
  See \code{\link{aRT}} the package organization.
}

\keyword{classes}
% vim: syntax=tex
