
\name{aRT}
\alias{aRT}
\alias{aRT-classes}

\title{R-TerraLib API}
\description{
aRT is a package integrating R with TerraLib.
TerraLib is a set of Geographic Information System (GIS) classes written
in C++ for support building GIS applications. It manipulates points, lines,
polygons and raster data (grids), storing them in a Data-Base Management
System (DBMS), and it has all above (and other) spatial queries.
Its main objectives are:
\itemize{
\item Encapsulate various DBMS, for example MySQL, PostgreSQL,
PostGIS and Oracle-spatial;
\item Give high-level support do spatial operations;
\item Enable database access without using SQL queries;
\item Retrieve spatial objects from DBMS in a proxy way.
}

The main motivation for the package development is to enable
the access to geographical databases and spatial/temporal operations
on them. \textsl{TerraLib} provides its own way to access a geographical database,
and it has several internal tables to control the data and
their relations.
}

\section{Classes}{
aRT is implemented using S4, and
there are some classes to encapsulate TerraLib
inside \R, and they are briefly described here.
  \describe{
	\item{\code{aRTconn}:}{Can to store a virtual DBMA connection and manipulates aRTdb objects. It can
         also perform some database administration tasks.}
	\item{\code{aRTdb}:}{Stores a real connection to a DBMA database, and can open/create aRTlayers.}
	\item{\code{aRTlayer}:}{Represents an information layer inside a database. Each layer manipulates
         only geometry, and is capable to do spatial queries as metrics and relations. Although
		 it cannot manipulate attributes, it can open/create aRTtables, aRTthemes and aRTqueriers.}
    \item{\code{aRTtable}:}{Stores a database table, and data is manipulated using data.frames.
         Each table has one specific type, and it can be static, temporal, external or media.
         When getting data from the table, you get all the data, without restrictions, unless you
		 use an aRTtheme.}
	\item{\code{aRTtheme}:}{Created from an aRTlayer, it can join tables and choose attribute
         restrictions. It can also create aRTquerier objects.}
    \item{\code{aRTquerier}:}{Encapsulates a database query. It can be temporal, if it was created from
         a temporal theme, and if a slicing was defined. It retrieves data one by one, slide by slide
         (if temporal), instead of all atributes/geometry once.}
    \item{\code{aRTvisual}:}{Defines a colors and style configuration to be used in aRTthemes.}
  }
}

\references{
\url{http://www.est.ufpr.br/aRT}\cr\url{http://www.terralib.org}}
\author{Pedro Ribeiro de Andrade Neto, Marcos Aurelio Carrero, Paulo Justiniano Ribeiro Junior}
\keyword{database}

\seealso{\code{CLASSNAME-class} for links to \code{CLASSNAME}}
% vim: syntax=tex
