/bin/sh

#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# This script runs under Debian/Linux
# Run this script using super-user

# Valid arguments:
# --no-qt
# --no-mysql
# --no-terraview
# --no-terralib
# --no-updatedb
# --tldir:/my/own/path:
# --add-system-variables

LINE="========================================================\n"
TEMP=/tmp/tmp.$$
CURRENT_DIR=`pwd`

printf $LINE
printf "                aRT : API R - TerraLib\n"
printf "             Copyright (C) 2003-2005  LEG\n"
printf $LINE
printf "\nThis script installs aRT dependencies"
printf "\n--help shows its usage\n"

# checking arguments vality
for i in "$@"; do
	case $i in
	--h|--help)
		printf "Options:\n"
	 	printf " --no-qt\n"
		printf " --no-mysql\n"
	 	printf " --no-terraview\n"
	 	printf " --no-terralib\n"
	 	printf " --no-updatedb\n"
	 	printf " --tldir:/my/own/path:     Default is /usr/local\n"
	 	printf " --add-system-variables    Appends /etc/bash.bashrc\n"
		exit 0;;	
	--no-mysql|--no-qt|--no-terraview|--no-terralib|--no-updatedb|--tldir:*:|--add-system-variables) ;;
	*) printf "Invalid argument: $i\nTry --help for args information\n"
	   exit 1;
	esac
done

# mysql installation
if echo $@|grep -e --no-mysql > /dev/null
then
	printf "MySQL installation ignored\n"
else
	printf $LINE
	printf "Installing MySQL\n"
	printf $LINE

	apt-get install mysql-server-4.1 
	apt-get install libmysqlclient14-dev
fi

# qt installation
if echo $@|grep -e --no-qt > /dev/null
then
	printf "Qt installation ignored\n"
else
	printf $LINE
	printf "Installing Qt\n"
	printf $LINE

	apt-get install libqt3-mt-dev
fi

# terraLib/terraView installation
if echo $@|grep -e --no-terralib > /dev/null
then
    printf "TerraLib installation ignored\n"
else

	# Choosing terraLib dir
	if echo $@|grep -e --tldir > /dev/null
	then
	    TERRALIB_DIR=$(echo $@|cut -d : -f 2)
	else
	    TERRALIB_DIR=/usr/local
	fi

	printf $LINE
	printf "Installing terraLib"
	if echo $@|grep -e --no-terraview > /dev/null
	then
		printf " (Terraview installation ignored)\n"
	else
		printf "/TerraView in $TERRALIB_DIR\n"
	fi

	printf "No CVS password required - just press <ENTER>\n"
	printf $LINE
	cd $TERRALIB_DIR
	mkdir -p terralib
	cd terralib

	cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib login
	cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib co -r v-3-1-0-beta src
	cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib co -r v-3-1-0-beta terralibx
	
	if echo $@|grep -e --no-terraview > /dev/null
	then
		cd terralibx/terralib
	else
		cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib co -r v-3-1-0-beta aplicativos/terraView/linux
		cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib co -r v-3-1-0-beta aplicativos/terraView/common
		cvs -d :pserver:anonymous@cvs.dpi.inpe.br:/home/terralib co -r v-3-1-0-beta aplicativos/ui
		cd aplicativos/terraView/linux
	fi
	
	printf "Compiling... (this operation will take some minutes)\n"
	make
fi

# updating db
if echo $@|grep -e --no-updatedb > /dev/null
then
	printf "updatedb ignored\n"
else
	printf $LINE
	printf "Updating database... (this operation will take some minutes)\n"
	printf $LINE
	updatedb
fi
	
# adding variables to /etc/bash.bashrc
if echo $@|grep -e --add-system-variables > /dev/null
then
    R_QUANTITY=$(locate libR.so |wc|cut -d ' ' -f 7)
    MYSQL_QUANTITY=$(locate libmysqlclient.a |wc|cut -d ' ' -f 7)
    LIBR_DIR_LOCATE=$(locate libR.so|head -n 1)
	LIBMYSQL_DIR_LOCATE=$(locate libmysqlclient.a|head -n 1)

    if [ -z "$LIBR_DIR_LOCATE" ]
    then
        printf "ERROR: libR.so not located!\n"
        printf "Install it and run updatedb first\n"
        exit 1
    fi
    if [ -z "$LIBMYSQL_DIR_LOCATE" ]
    then
        printf "ERROR: libmysqlclient.a not located!\n"
        printf "Install it and run updatedb first\n"
        exit 1
    fi

    LIBR_DIR=${LIBR_DIR_LOCATE/libR.so/}
	LIBMYSQL_DIR=${LIBMYSQL_DIR_LOCATE/libmysqlclient.a/}

    if [ "$R_QUANTITY" -ne "1" ]
    then
        printf "WARNING: More than one libR.so located\n"
        locate libR.so
        printf "\nOption choosed: $LIBR_DIR\n"
    fi

    if [ "$MYSQL_QUANTITY" -ne "1" ]
    then
        printf "WARNING: More than one libmysqlclient.a located\n"
        locate libmysqlclient.a
        printf "\nOption choosed: $LIBMYSQL_DIR\n"
    fi

	# adding lines to a tmp file
    cat > $TEMP <<- EOF

		# lines added by install-aRT-dep.sh 
		TERRALIBDIR=$TERRALIB_DIR/terralib
		LIBRDIR=$LIBR_DIR
		LIBMYSQLCLIENTDIR=$LIBMYSQL_DIR
	EOF

    cat >> $TEMP <<- 'EOF'
		LD_LIBRARY_PATH=$LD_LIBRARY_PATH:\
		$TERRALIBDIR/terralibx/terralib:\
		$TERRALIBDIR/terralibx/tiff:\
		$TERRALIBDIR/terralibx/shapelib:\
		$TERRALIBDIR/terralibx/stat:\
		$TERRALIBDIR/terralibx/image_processing:\
		$LIBRDIR

		export TERRALIBDIR LIBMYSQLCLIENTDIR LIBRDIR LD_LIBRARY_PATH
	EOF

	printf "Do you want to edit the variables? [y/n] "
	read OPTION

	if echo $OPTION|grep y > /dev/null
	then
		vim $TEMP
	fi

	cat $TEMP >> /etc/bash.bashrc
fi

printf "Installation complete\n"
cd $CURRENT_DIR

