#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

require(sp)

#====================================================================
# preparing .aRTspdefs object which stores class definitions for
# building objects outside R.
# It is necessary to avoid gc() to kill them
.aRTspdefs = list()
.aRTspdefs$polygon  = methods:::getClassDef("Polygon")
.aRTspdefs$polygons = methods:::getClassDef("Polygons")
.aRTspdefs$line     = methods:::getClassDef("Line")
.aRTspdefs$lines    = methods:::getClassDef("Lines")

.aRTinitSpDefs = function()
{
    .Call("cppInitSpDefs", .aRTspdefs, PACKAGE="aRT")
    return(invisible())
}
#====================================================================

# return a vector of strings with the IDs
getID = function(object)
{
	if(class(object) == "SpatialPointsDataFrame")
	{
		if(is.null(object$ID)) return(as.vector(object$id))
		else                   return(as.vector(object$ID))
    }
	if(class(object) == "SpatialLines")    return(getSLLinesIDSlots(object))
	if(class(object) == "SpatialPolygons") return(getSpPPolygonsIDSlots(object))
	stop("Not implemented yet")
}	

setMethod("as.aRTgeometry", "SpatialPoints", function(object) {
	stop(paste("aRT does not support objects of this class.",
	           "Use SpatialPointsDataFrame with an attribute called ID instead."))
})

setMethod("as.aRTgeometry", "SpatialPointsDataFrame", function(object) {
	if(!any(names(object@data) == "ID"))
		stop("The data.frame must have a column called 'ID'")
	
	new("aRTgeometry", object)
})

setMethod("as.aRTgeometry", "SpatialLines", function(object) {
	new("aRTgeometry", object)
})

setMethod("as.aRTgeometry", "SpatialPolygons", function(object) {
	new("aRTgeometry", object)
})

