#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# note that this function will not work with spatialpoints because
# there is no .aRTdraw defined for this class (it does not have ID)
setMethod("aRTplot", "Spatial", function(geom, id=NULL, add=FALSE, ...) {
	if(!add)
	{
		if( !is.null(id) )
		{
			ids=getID(geom)
			pos=unlist(lapply(id, function(x) which(ids == x)))
			geom = geom[pos]
			id=NULL
		}

		xr <- geom@bbox[1,]
	    yr <- geom@bbox[2,]
	    frame()
	    plot.window(xlim=xr, ylim=yr, asp=1)
		box()
	}
	.aRTdraw(geom, id=id, ...)
})

setMethod(".aRTdraw", "SpatialPointsDataFrame", function(geom, id=NULL, ...) {
    if(is.null(id)) points(geom, ...)
    else
	{
		for(i in 1:(dim(geom)[1]))
		{
			if(any(id == as.vector(geom@data$ID)[i]))
			{
				points(geom[i,],...)
			}
		}
	}
})

setMethod(".aRTdraw", "SpatialPolygons", function(geom, id=NULL, ...) {
	for(i in 1:length(geom@polygons))
	{
		if(is.null(id) || any(id == geom@polygons[[i]]@ID))
		{
			for(j in 1:length(geom@polygons[[i]]@Polygons))
			{
				polygon(geom@polygons[[i]]@Polygons[[j]]@coords, ...)
			}
		}
	}
})

setMethod(".aRTdraw", "SpatialLines", function(geom, id=NULL, ...) {
    for(i in 1:length(geom@lines))
    {
        if(is.null(id) || any(id == geom@lines[[i]]@ID))
        {
            for(j in 1:length(geom@lines[[i]]@Lines))
            {
                lines(geom@lines[[i]]@Lines[[j]]@coords, ...)
            }
        }
    }
})

setMethod("plot", "aRTtheme", function(x, y, ...) {
  out <- openQuerier(x, att=FALSE)
  plot(getData(out), ...)
  return(invisible())
})

setMethod("plot", "aRTlayer", function(x, y, ...) {
  summ = summary(x)
  iferr = function(xx) { if(is.null(xx)) stop("Error loading data") }
  if(summ$raster == "yes") { out <- getRaster(x);   iferr(out); image(out, asp=1, ...) }
  if(summ$polygons > 0   ) { out <- getPolygons(x); iferr(out); aRTplot(out, ...)      }
  if(summ$lines > 0      ) { out <- getLines(x);    iferr(out); aRTplot(out, ...)      }
  if(summ$points > 0     ) { out <- getPoints(x);   iferr(out); aRTplot(out, ...)      }
  box()
  return(invisible())
})

