#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

setMethod("initialize", "aRTtheme", function(.Object,
                                             parent = NULL,
											 themename = summary(parent)$layer,
											 create = FALSE,
											 tables = NULL,
											 viewname = themename,
                                             attrest = "",
                                             id = NULL)
{
# if tables == NULL the theme can't be created
# tables == showTables(aRTlayer) does not warrant that the theme will be opened,
# because TerraLib has some invalid table combinations (TODO: put it into help)
# tables and viewname are needed only when a new theme is going to be created
# themes can be created only from aRTlayers
  if (is.null(themename)) stop("themename cannot be NULL")

  if (is.object(parent) && class(parent) == "aRTlayer")
  {
	if ( is.null(tables) && summary(parent)$raster == "no") tables = showTables(parent)

	if(!is.null(id) )
    {
		if(is.null(tables)) stop("Can't select ids without a table\n")
		
		t = new("aRTtable", parent, table=tables[1])

		key = summary(t)$keys[1]
        
		# if attrest != "" we will add the two restrictions to the theme
		if(attrest == "") rest = paste(key, " = '", id[1], "'", sep="")
		else              rest = paste(attrest, " and (", key, " = '", id[1], "'", sep="")
		
		for(i in 2:length(id))
		{
			rest = paste(rest, " or ", key, " = '", id[i], "'", sep="")
		}

		if(attrest != "") rest = paste(rest, ")")

		attrest = rest
	}
    out <- .aRTcall(parent,
	                "cppOpen",
					themename = themename,
	  		        create = as(create, "integer"),
			        viewname = viewname,
			        tables = tables,
					attrest = attrest)
  }
  else if(is.object(parent) && class(parent) == "aRTdb")
	  out <- .aRTcall(parent,
	                  "cppOpen",
					  themename = themename)
  else error("Invalid parent object")
  
  if (is.null(out)) stop("Could not create the aRTtheme object\n")

  .Object@pointer <- out
  reg.finalizer(.Object@pointer, .aRTremove)
  .Object
})

setMethod("setVisible", "aRTtheme", function(object, points=NULL, lines=NULL, polygons=NULL, check=NULL)
{
  if(!is.logical(c(points, lines, polygons, check)))
  	stop("All arguments must be logical values")

  .aRTcall(object,"cppSetVisible", points = points, lines = lines, polygons = polygons, check = check)
  return(invisible())
})

setMethod("getData", "aRTtheme", function(object) {
 q=openQuerier(object)
 getData(q)
})

setMethod("openQuerier", "aRTtheme", function(object, geom = c("", "points", "lines", "polygons", "none"), att=TRUE, ...)
{
  geom = match.arg(geom)
  err = "Theme has more than one geometry, choose one value for geom"
  if(geom == "") # if there is more than one geometry and the user
                 # does not specify the geom we stop with an error
  {
    sum = summary(object)

    if(sum$polygons == "yes") geom = "polygons"
    if(sum$lines    == "yes") { if(geom == "") geom = "lines"  else stop(err) }
    if(sum$points   == "yes") { if(geom == "") geom = "points" else stop(err) }
    if(geom == "") stop("Theme does not have any geometry")
  }

  new("aRTquerier", object, geom=geom, loadatt=att, ...)
})

