#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# generateids is used in static tables for generating ids from the
# layer geometries.
# only external tables are allowed to be built from aRTdb's
setMethod("initialize", "aRTtable", function(.Object, 
                                             parent,
                                             tablename = NULL,
										     create = FALSE,
											 type = c("default",
                                                      "static",
                                                      "media",
                                                      "external",
                                                      "event",
                                                      "dynatt",
                                                      "alldyn",
                                                      "dyngeom"),
											 generateids = NULL,
											 id = "id",
											 length = 16,
											 itimeatt = "itime",
											 ftimeatt = "ftime")
{
  type = match.arg(type)
  if (is.object(parent) && class(parent) == "aRTlayer")
  {
    if(is.null(tablename)) tablename = summary(parent)$layer
    if(type == "default") type = "static"
    if(type == "external") stop("Only aRTdb can create external tables")

	if( is.null(generateids) ) # generateids is useful only with static tables
	{
		if(type == "static") generateids = TRUE
		else                 generateids = FALSE
	}

    .Object@pointer = .aRTcall(parent,
							   "cppLTable",
    	                       tablename = tablename,
						       create = create,
							   type = type,
							   generateids = generateids,
							   id = id,
							   itimeatt = itimeatt,
							   ftimeatt = ftimeatt,
							   length = as(length, "integer"))

  }
  else if (is.object(parent) && class(parent) == "aRTdb")
  {
	if(is.null(tablename)) stop("tablename cannot be NULL if creating from database")
	if(type == "default") type = "external"
	if(type != "external") stop("aRTdb can only create external tables")
		
	.Object@pointer = .aRTcall(parent,
                               "cppDTable",
		                	   tablename = tablename,
					           create = create,
						       type = type,
							   generateids = FALSE,
							   id = id,
							   length = as(length, "integer"))
	}
	else
	{
    	stop("Argument \"parent\" must be an object of aRTlayer or aRTdb\n")
	}

  	reg.finalizer(.Object@pointer, .aRTremove)
	.Object
})

setMethod("createRelation","aRTtable",
           function(object,
		            attr,
					rtable,
					rattr = attr)
{
	summrtable = summary(rtable)
	summobject = summary(object)

	if(!is.object(rtable) || class(rtable) != "aRTtable")
		stop("Argument \"rTable\" must be an aRTtable")
	if(!any(summobject$columns == attr))
		stop(paste("Table", summary(table)$name, " does not have attribute \"", attr, "\"", sep = ""))
	if(!any(summrtable$columns == rattr))
		stop(paste("Table", summrtable$name, " does not have attribute \"", rattr, "\"", sep = ""))
	
	if(summobject$type == "external")
		stop("Object can't be an external table")
	
	if(summrtable$type != "external")
		stop("Relation table must be an external table")
	
	.aRTcall(object, "cppCreateRelation", attr=attr, rtable=summrtable$name, rattr=rattr)
})

setMethod("addRows", "aRTtable", function(object, data) {
	if( !is.data.frame(data)) stop("data must be a data.frame")

    id=summary(object)$keys

	if(!any(id[1] == colnames(data)))
	{
	    cat("Using rownames as id\n")
		l=list()
		l[[id]]=rownames(data)
		data=cbind(data, l)
	}

	.aRTcall(object,
             "cppAddRows",
		     colnames= colnames(data),
		     length=length(rownames(data)),
		     matrix  = as.matrix(format.data.frame(data, trim=T)))
			   # format.data.frame to convert the elements to string
	return(invisible())
})

setMethod("createColumn", "aRTtable",
		  function(object,
                   colname,
				   type="c",
				   length=10,
				   key=FALSE,
				   decimals=3,
				   autonumber=FALSE) {
	.aRTcall(object,
             "cppCreateColumn",
		     colname=colname,
		     type=type,
			 length=as(length, "integer"),
			 decimals=as(decimals, "integer"),
			 autonumber=autonumber,
			 key=key)
	return(invisible())
})

setMethod("updateColumns", "aRTtable",function(object, data){
	summ = summary(object)
	columns = summ$columns
	keys = summ$keys
	table = summ$name
	
	# check if some attribute does not belong to the table, and insert the attribute
    colnames = colnames(data)
    classes <- substr(sapply(data, class),1,1)
    for(i in 1:length(colnames))
    {
		if(any(columns == colnames[i]))
			.catSilent("Checking for column \'", colnames[i], "\' in table \'", table, "\' ... yes\n", sep="")
		else
		{
			createColumn(object, colnames[i], type = classes[i], length=max(nchar(as.matrix(data[i]))))
		}
    }

	.aRTcall(object,
             "cppUpdateColumns",
		     colnames= colnames(data),
		     length=length(rownames(data)),
		     matrix  = as.matrix(format.data.frame(data)))
			 # format.data.frame to convert the elements to string

	return (invisible())
})

# returns a terralib format string to representing dates
toDate=function(year = 0, month = 1, day = 1, hour = 0, minute = 0, second = 0)
{
	z = ""
	if     (year < 10)   z = "000"
	else if(year < 100)  z = "00"
	else if(year < 1000) z = "0"
	resp = paste(z, year, sep="")

	sep = c("-","-"," ",":",":")
	times = c(month, day, hour, minute, second)
	
	for(i in 1:length(times))
	{
		z = ""
		if(times[i] < 10) z = "0"
		resp = paste(resp, sep[i], z, times[i], sep="")
	}
	return(resp);
}

setMethod("getData", "aRTtable", function(object) {
	.Call("cppGetTableData", object@pointer, PACKAGE="aRT")
})


