#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

setMethod("initialize", "aRTgeometry", function(.Object, data = NULL, .external = NULL)
{
  if( !is.null(.external) ) pointer = .external
  else pointer = .Call("cppGeometry", data, PACKAGE="aRT")

  .Object@pointer <- pointer
  reg.finalizer(.Object@pointer, .aRTremove)
  .Object
})

setMethod("getGeometry", "aRTgeometry", function(object)
{
  data = .aRTcall(object, "cppGetGeo")

  sum = summary(object)

  if(sum$type == "points")
  {
    xy.sp=SpatialPoints(data$mat)
    df = data.frame(ID = data$ID)
    data = SpatialPointsDataFrame(xy.sp, df)		
  }
  else if(sum$type == "lines")    { data = SpatialLines(data) }
  else if(sum$type == "polygons") { data = SpatialPolygons(data, 1:length(data)) }

  data
})

