#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

setMethod("initialize", "aRTdb", function(.Object,
                                          aRT,
										  dbname,
										  create = FALSE,
										  update = FALSE,
										  .external = NULL)
{
  if( !is.null(.external) )
  {
  	cat("Using a TerraLib application external pointer\n")
	.Object@pointer <- .Call("cppOpenDbPointer",.external,PACKAGE="aRT")
	# never think in reg.finalizer. This pointer comes from TerraView!
	return(.Object)
  }

  if (!is.object(aRT) || class(aRT) != "aRTconn")
    stop("Argument \"aRTconn\" must be an object of aRTconn\n")
  
  if (is.null(dbname)) stop("dbname can not be NULL")

  out <- .aRTcall(aRT,
                  "cppOpen",
		 	      dbname=dbname,
		 	      create=as(create, "integer"),
			      update=as(update, "integer"))

  if (is.null(out))
    stop("Could not create the aRTdb object\n")
  .Object@pointer <- out
  reg.finalizer(.Object@pointer, .aRTremove)
  .Object
})

setMethod("openLayer", "aRTdb", function(object, lname) {
	if(!any(showLayers(object) == lname))
        stop("Layer does not exist\n")
	new("aRTlayer", object, l=lname)
})

setMethod("createLayer", "aRTdb", function(object, lname, proj=NA) {
	if(any(showLayers(object) == lname))
        stop("Layer already exists\n")
	new("aRTlayer", object, l=lname, c=T, proj=proj)
})

setMethod("showLayers", "aRTdb",    function(object) { .aRTcall(object, "cppList")       })
setMethod("showTables", "aRTdb",    function(object) { .aRTcall(object, "cppDShowTables")})
setMethod("showViews",  "aRTdb",    function(object) { .aRTcall(object, "cppShowViews")  })

# import an external table
setMethod("importTable", "aRTdb", function(object, table, id, data)
{
	t = new("aRTtable", db, table=table, id=id, c=T, gen=T)

    colnames = colnames(data)
    classes <- substr(sapply(data, class),1,1)
    for(i in 1:length(colnames))
    {
		if(colnames[i] != id)
		{
			createColumn(t, colnames[i], type = classes[i], length=max(nchar(as.matrix(data[i]))))
		}
    }
	addRows(t, data)
	t
})

setMethod("importShape", "aRTdb", function(object, layer, proj = NA, ...) {
  if(any(showLayers(db) == layer))
      stop("Layer already exists\n")

  l = new("aRTlayer", object, l=layer, proj=proj, c=T)
  addShape(l, ...)
  return(l)
})

setMethod("deleteLayer", "aRTdb", function(object, layername, force=FALSE) {
	if(.aRTconfirm(force))
	    .aRTcall(object, "cppDeleteLayer", layername=layername)
	return(invisible())
})

setMethod("deleteTable", "aRTdb", function(object, tablename, force=FALSE) {
	if(.aRTconfirm(force))
    .aRTcall(object, "cppDeleteTable", tablename=tablename)
	return(invisible())
})

setMethod("createTable", "aRTdb", function(object, tablename, type="default", ...) {
	if(any(showTables(object) == tablename))
   	    stop("Table already exists\n")
	new("aRTtable", object, t=tablename, type="external", c=TRUE, ...)
})

setMethod("openTable", "aRTdb", function(object, tablename=NULL, type="default") {
	if(type=="media")
		ret = new("aRTtable", object, type=type)
	else
	{	
		if(!any(showTables(object) == tablename))
    	    stop("Table does not exist\n")
		ret = new("aRTtable", object, tab=tablename, type=type)
	}
	return(ret)
})

