#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# aRT.R: calls C++ functions of main.cpp.
# All this functions only check for user argument errors.
# Other errors are checked in the next layers.

setMethod("initialize", "aRTconn", function(.Object,
                                            user = system("echo $USER", TRUE),
									        password = "",
										    port = 3306,
										    host = "localhost",
										    dbms = NULL)
{
  if(is.null(dbms))
  {
    if(FALSE) dbms = "postgre"
    if(TRUE)   dbms = "mysql"
  }

  if(dbms == "mysql"  & !TRUE)   stop("MySQL DBMS not found in the installation")
  if(dbms == "posgre" & !FALSE) stop("PostgreSQL DBMS not found in the installation")
  
  .Object@pointer <- .Call("cppNewaRT", user, password, port, host, dbms, PACKAGE="aRT")
  reg.finalizer(.Object@pointer, .aRTremove)
  .Object
})

openConn = function(...) {
	new("aRTconn", ...)
}

setMethod("openDb", "aRTconn", function(object, dbname, ...) {
	if(!any(showDbs(object) == dbname))
        stop("Database does not exist\n")
	new("aRTdb", object, dbname=dbname, ...)
})

setMethod("createDb", "aRTconn", function(object, dbname) {
	if(any(showDbs(object) == dbname))
        stop("Database already exists\n")
	new("aRTdb", object, dbname=dbname, c=T)
})

setMethod("addUser", "aRTconn", function(object, userName) {
	   .aRTcall(object, "cppAddUser", userName=userName)
	   return (invisible())
})

setMethod("showDbs", "aRTconn",  function(object) { .aRTcall(object, "cppList")       })

setMethod("deleteDb", "aRTconn", function(object, dbname, force=FALSE) {
	.catSilent("Checking for database \'", dbname, "\' ... ", sep="")
	if(! any(showDbs(object) == dbname) )
	{
		.catSilent("no\n")
		warning(sprintf("Database '%s' does not exist.", dbname))
		return(invisible())
	}
	.catSilent("yes\n")

	if(.aRTconfirm(force))
		.aRTcall(object, "cppDeleteDb", dbname=dbname)
	return(invisible())
})

