.packageName <- "aRT"
#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

require(sp)

.mkGen = function(func, set)
{
	if(!isGeneric(func)) setGeneric(func, set)
	return(invisible())
}

.mkGen(".aRTcall", function(obj, call, ...)     standardGeneric(".aRTcall"))
.mkGen("summary",  function(object, ...)        standardGeneric("summary"))
.mkGen("plot",     function(x, y, ...)          standardGeneric("plot"))
.mkGen("aRTplot",  function(geom, id=NULL, add=FALSE, ...) standardGeneric("aRTplot"))
.mkGen(".aRTdraw", function(geom, id=NULL, ...) standardGeneric(".aRTdraw"))

.mkGen("as.aRTgeometry", function(object) standardGeneric("as.aRTgeometry"))

# openDb has "..." because of the TerraView integration (.external)
.mkGen("openDb",      function(object, dbname, ...)    standardGeneric("openDb"))
.mkGen("openLayer",   function(object, lname)          standardGeneric("openLayer"))
.mkGen("openTheme",   function(object, tname)          standardGeneric("openTheme"))
.mkGen("openQuerier", function(object, ...)            standardGeneric("openQuerier"))
.mkGen("openTable",   function(object, tablename, ...) standardGeneric("openTable"))
.mkGen("createView",  function(object, viewName)       standardGeneric("createView"))
.mkGen("createDb",    function(object, dbname)         standardGeneric("createDb"))
.mkGen("createLayer", function(object, lname, ...)     standardGeneric("createLayer"))
.mkGen("createTheme", function(object, tname=NULL, ...)standardGeneric("createTheme"))
.mkGen("createTable", function(object, tablename, ...) standardGeneric("createTable"))

.mkGen("createRelation", function(object, attr, rtable, rattr = attr)
	standardGeneric("createRelation"))

.mkGen("createColumn", function(object, 
                                colname,
								type="c",
								length=10,
								key=FALSE,
								decimals=3,
								autonumber=FALSE) standardGeneric("createColumn"))

.mkGen("showDbs",     function(object) standardGeneric("showDbs"))
.mkGen("showLayers",  function(object) standardGeneric("showLayers"))
.mkGen("showTables",  function(object) standardGeneric("showTables"))
.mkGen("showViews",   function(object) standardGeneric("showViews"))
.mkGen("showThemes",  function(object) standardGeneric("showThemes"))

.mkGen("importTable", function(object, table, id, data) standardGeneric("importTable"))
.mkGen("importShape", function(object, layer, proj = NA, ...) standardGeneric("importShape"))

.mkGen("deleteDb",    function(object, dbname,    force=FALSE) standardGeneric("deleteDb"))
.mkGen("deleteTheme", function(object, themename, force=FALSE) standardGeneric("deleteTheme"))
.mkGen("deleteLayer", function(object, layername, force=FALSE) standardGeneric("deleteLayer"))
.mkGen("deleteView",  function(object, viewname,  force=FALSE) standardGeneric("deleteView"))
.mkGen("deleteTable", function(object, tablename, force=FALSE) standardGeneric("deleteTable"))

.mkGen("addUser",     function(object, userName) standardGeneric("addUser"))
.mkGen("addPoints",   function(object, points)   standardGeneric("addPoints"))
.mkGen("addPolygons", function(object, polygons) standardGeneric("addPolygons"))
.mkGen("addLines",    function(object, lines)    standardGeneric("addLines"))
.mkGen("addRaster",   function(object, value)    standardGeneric("addRaster"))
.mkGen("addRows",     function(object, data)     standardGeneric("addRows"))
.mkGen("addShape",    function(object, file, table, id, length = 10) standardGeneric("addShape"))

.mkGen("getBox",      function(object) standardGeneric("getBox"))
.mkGen("getGeometry", function(object) standardGeneric("getGeometry"))
.mkGen("getRaster",   function(object) standardGeneric("getRaster"))
.mkGen("getProj",     function(object) standardGeneric("getProj"))
.mkGen("getVisual",   function(object) standardGeneric("getVisual"))
.mkGen("getPoints",   function(object, table=NULL, as.sp=TRUE) standardGeneric("getPoints"))
.mkGen("getLines",    function(object, as.sp=TRUE) standardGeneric("getLines"))
.mkGen("getPolygons", function(object, as.sp=TRUE) standardGeneric("getPolygons"))
.mkGen("getData",     function(object, ...)        standardGeneric("getData"))

.mkGen("getDistance",     function(object, id, layer=NULL) standardGeneric("getDistance"))
.mkGen("getNN",           function(object, layer=object, id, quantity=1) standardGeneric("getNN"))

.mkGen("getMetric",       function(object, metric, id=NULL, distance=NULL)
	standardGeneric("getMetric"))

.mkGen("getSetOperation", function(object, operation, id, as.sp=TRUE)
	standardGeneric("getSetOperation"))

.mkGen("getOperation",    function(object, operation, id=NULL, distance=NULL, as.sp=TRUE)
	standardGeneric("getOperation"))

.mkGen("getRelation",     function(object, relation, layer=object, id=NULL)
	standardGeneric("getRelation"))

.mkGen("nextFrame",    function(object)       standardGeneric("nextFrame"))
.mkGen("updateColumns",function(object, data) standardGeneric("updateColumns"))

.mkGen("setVisible", function(object, points, lines, polygons, check)
	standardGeneric("setVisible"))

.mkGen("setVisual",  function(object, visual, attribute = NULL, mode = "e")
	standardGeneric("setVisual"))

