# Exemplo de relacoes espaciais utilizando os
# trs tipos de geometria.
# Este exemplo utiliza os dados de Recife
#
# (C) 2005 LEG

require(aRT)

a = new("aRT")

if(any(showDbs(a)=="recife")) deleteDb(a, "recife", force=T)

db = new("aRTdb",a,db="recife", c=T)

lbairros    = new("aRTlayer", db, l="Bairros", c=T)
larmadilhas = new("aRTlayer", db, l="Armadilhas", c=T)
ldrenagem   = new("aRTlayer", db, l="Drenagem", c=T)

data(recife.districts)
data(recife.points)
data(recife.sewers)

addPolygons(lbairros,    recife.districts)
addPoints  (larmadilhas, recife.points)
addLines   (ldrenagem,   recife.sewers)

tbairros    = new("aRTtable",lbairros,   "t_bairros",   gen=T, c=T)
tarmadilhas = new("aRTtable",larmadilhas,"t_armadilhas",gen=T, c=T)
tdrenagem   = new("aRTtable",ldrenagem,  "t_drenagem",  gen=T, c=T)

# isto demora um pouco... pegar as geometrias dos layers
# utilizados para nao precisar fazer mais
getGeometry(lbairros)   ->geobairros
getGeometry(larmadilhas)->geoarmadilhas
getGeometry(ldrenagem)  ->geodrenagem

par(mfcol=c(2,2), mar=c(3,3,.5,.5))

# plotando bairros e armadilhas
plot(geobairros, col="red")
plot(geoarmadilhas, add=T)

# plotando rede de drenagem da cidade
plot(geobairros, col="gray", lty=0)
plot(geodrenagem, add=T, col="blue")

## Relacoes espaciais
# 1. todos os bairros que Contem armadilhas
getRelation(lbairros, "contains", larmadilhas)->rel1

# 2. todos os vizinhos (touch) dos bairros que possuem armadilhas
getRelation(lbairros, "touch", id=rel1)->rel2

plot(geobairros, col="gray", lty=0)
plot(geobairros, col="green", add=T, id=rel2)
plot(geobairros, col="yellow", add=T, id=rel1)
# nao desenhei as armadilhas porque senao nao d pra ver os bairros (fica preto)
#plot(geoarmadilhas, add=T)

# 3. drenagens que cruzam os bairros que tem armadilhas
getRelation(ldrenagem, "crosses", layer=lbairros, id=rel1)->rel3

# 4. drenagens que estao contidas (within) nos bairros que tem armadilhas
getRelation(ldrenagem, "within", layer=lbairros, id=rel1)->rel4

plot(geobairros, col="gray", lty=0, id=rel1)
plot(geobairros, col="gray", lty=0, add=T)
plot(geobairros, col="yellow", lty=0, id=rel1, add=T)
plot(geodrenagem, add=T)
plot(geodrenagem, add=T, col="green", id=rel3)
plot(geodrenagem, add=T, col="red", id=rel4)

# gerando temas com as mesmas imagens vistas no R
th1 = new("aRTtheme", lbairros,    th = "bairros1",  view="bairros", cre=T)
th2 = new("aRTtheme", larmadilhas, th = "armadilhas1", view="bairros", cre=T)

setVisual(th1, visualPolygons(color="red"))
setVisual(th2, visualPoints(pch=22))

setVisible(th1)
setVisible(th2)

th3 = new("aRTtheme", lbairros,  th = "bairros2",  view="drenagem", cre=T)
th4 = new("aRTtheme", ldrenagem, th = "drenagem2", view="drenagem", cre=T)

setVisual(th3, visualPolygons(color="gray", ccolor="gray"))
setVisual(th4, visualLines(color="blue"))

setVisible(th3)
setVisible(th4)

th5 = new("aRTtheme", lbairros, th = "vizinhos3", view="vizinhos", cre=T, id=unique(rel2))
th6 = new("aRTtheme", lbairros, th = "contem3",   view="vizinhos", cre=T, id=unique(rel1))
th7 = new("aRTtheme", lbairros, th = "todos3",    view="vizinhos", cre=T)

setVisual(th5, visualPolygons(color="green"))
setVisual(th6, visualPolygons(color="yellow"))
setVisual(th7, visualPolygons(color="gray", ccolor="gray"))


setVisible(th5)
setVisible(th6)
setVisible(th7)

th8 = new("aRTtheme", ldrenagem, th = "cruzam4",   view="final", cre=T, id=unique(rel3))
th9 = new("aRTtheme", ldrenagem, th = "contem4",   view="final", cre=T, id=unique(rel4))
th10 = new("aRTtheme", lbairros,  th = "vizinhos4", view="final", cre=T, id=unique(rel1))
th11 = new("aRTtheme", lbairros,  th = "bairros4",  view="final", cre=T)

setVisual(th8, visualLines(color="blue"))
setVisual(th9, visualLines(color="red"))
setVisual(th10, visualPolygons(color="yellow"))
setVisual(th11, visualPolygons(color="gray", ccolor="gray"))

setVisible(th8)
setVisible(th9)
setVisible(th10)
setVisible(th11)
