# Exemplo de manipulacao de poligonos no aRT
# utiliza o conjunto de dados catarina
#
# (C) 2005 LEG

require(aRT)
data(pol3)

plot(pol3)

con <- new("aRT", user = "pedro")
showDbs(con)

if(any(showDbs(con)=="pol3")) deleteDb(con, "pol3", force=T)

db <- new("aRTdb", con, db="pol3", create=T)

l_pol <- new("aRTlayer", db, layer="poligonos", create=T)

addPolygons(l_pol, pol3)
new("aRTtable",l_pol,"table_pol",c=T)

par(mfcol=c(2,3), mar=c(3,3,.5,.5))

plot(l_pol)

# Calculando algumas metricas
getMetric(l_pol, "h")->hull
getMetric(l_pol, "b", d=5000)->buffer

plot(l_pol, col="gray", lty=0)
plot(l_pol, id=c("1"), add=T, col="green")
plot(hull, id=c("1"), add=T, border="blue")
plot(buffer, id=c("1"), add=T, border="red", lty=2)

plot(l_pol, col="gray", lty=0) 
plot(l_pol, id=c("2"), add=T, col="green")
plot(hull, id=c("2"), add=T, border="blue")
plot(buffer, id=c("2"), add=T, border="red", lty=2)

plot(l_pol, col="gray", lty=0) 
plot(l_pol, id=c("3"), add=T, col="green")
plot(hull, id=c("3"), add=T, border="blue")
plot(buffer, id=c("3"), add=T, border="red", lty=2)

# calculando a uniao e interseccao de alguns conjuntos
getSetMetric(l_pol, "u", id=c("2","3"))->datau
getSetMetric(l_pol, "i", id=c( "2","3"))->datai

# inserindo estes resultados em um novo layer e
# calculando as suas cascas convexas
l2<-new("aRTlayer", layer="ui", db, c=T)
data<-list()
data$id<-c("1", "2")
data$polygons<-c(datau$polygons, datai$polygons)
class(data)<-"aRTgeometry"
addPolygons(l2, data)

new("aRTtable",l2,"table_ui",c=T)

getMetric(l2, "h")->hull2

# plotando o resultado das operacoes juntamente
# com as suas cascas convexas
plot(l_pol, col="gray", lty=0) 
plot(datau, col="yellow", add=T)
plot(hull2, id=c("1"), border="blue", add=T)

plot(l_pol, col="gray", lty=0) 
plot(datai, col="orange", add=T)
plot(hull2, id=c("2"), border="blue", add=T)

