# Exemplo de como criar um banco de dados
# no aRT, a partir do conjunto de dados
# parana, do pacote geoR
#
# (C) 2005 LEG

##
## Carregando pacotes/funcoes
##
require(geoR)
require(aRT)

##
## Exemplo 1: dados parana
##
data(parana)
points(parana, bor=borders)

## criando uma conexao com o SGBD (MySQL)
con <- new("aRT", user = "pedro")
showDbs(con)
## opcoes para: host, port, user, password

if(any(showDbs(con)=="pr")) deleteDb(con, "pr", force=T)

## criando um novo BD
con
pr <- new("aRTdb", con, db="pr", create=T)

##
## 1.1 criando um layer para armazenar os dados
##
l_dados <- new("aRTlayer", pr, layer="dados", create=T)

## carregando geometrias (pontos)
artcoords <- .gr2aRTpoints(parana)
addPoints(l_dados, artcoords)
new("aRTtable", l_dados, "t_dados", c=T)

plot(l_dados)

# inserindo atributos (so depois de fechar geometria)
artdata <- .gr2aRTattributes(parana)

names(artdata)
#addColumns(l_dados, artdata)

## criando vistas e temas automaticas para o TV (opcional)
tema_dados <- new("aRTtheme", l_dados, th="estacoes", view = "view", create=T)

##
## 1.2 criando um layer para armazenar o contorno do estado
##

artpols <- .gr2aRTpolygons(parana)

l_pol<-new("aRTlayer", pr, layer="contorno", create=T)
addPolygons(l_pol, artpols)
new("aRTtable", l_pol, "t_pol", c=T)
plot(l_pol)

tema_pol<-new("aRTtheme", l_pol, th="contorno", cr=T, view="view")

#
# Executando um algoritmo para anlise espacial (krigagem)
#
ml <- likfit(parana, trend="1st", ini=c(1000, 100))
gx <- seq(50,800, by=10)
gy <- seq(-100,650, by=10)
loc0 <- expand.grid(gx,gy)
points(parana, bor=borders)
points(loc0, pch=".", col=2)
loc1 <- polygrid(loc0, bor=parana$bor)
points(loc1, pch="+", col=4)

KC <- krige.control(trend.d="1st", trend.l="1st", obj=ml)
kc <- krige.conv(parana, loc=loc0, krige= KC, bor=parana$borders)
save.image()

image(kc, col=terrain.colors(15))

# preparando objeto para aRT
georpred <- prepare.graph.kriging(locations=loc0, borders=parana$borders, values=kc$pred)
artpred <- .gr2aRTraster(georpred)

l_pred <- new("aRTlayer", pr, layer="pred", create=T)

addRaster(l_pred, artpred)

# se o nome do tema for omitido, o seu nome sera o mesmo do layer
th<-new("aRTtheme", l_pred, th="raster", cr=T, view="view")

setVisual(th, visualRaster(), mode="r")

# existe um bug ao desenhar o raster, pois ele
# aparece deslocado para a direita...
plot(l_pred, col=terrain.colors(15))
plot(l_dados, add=T)
plot(l_pol, add=T)

getMetric(l_pol, "a")
getMetric(l_pol, "l")

