/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

extern "C"
{

const int dumpLimit = 20;
	
void printSEXP(SEXP e)
{
    int i = 0;

    switch( TYPEOF(e) )
    {
        case NILSXP:
            printf("NULL value\n");
            return;

        case LANGSXP:
            printf("language construct\n");
            return;

        case REALSXP:
            if (LENGTH(e) > 1)
            {
                printf("Vector of real variables: ");
                while( i < LENGTH(e) )
                {
                    printf("%f",REAL(e)[i]);
                    if (i < LENGTH(e) - 1) printf(", ");
                    if (dumpLimit && i > dumpLimit) { printf("..."); break; }
                    i++;
                }
                putchar('\n');
            }
            else printf( "Real variable %f\n", *REAL(e) );
            return;
        case EXPRSXP:
            printf( "Vector of %d expressions:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit){ printf("...");  break; }
                printSEXP( VECTOR_ELT(e,i) );
                i++;
            }
            return;

         case INTSXP:
            printf( "Vector of %d integers:\n", LENGTH(e) );

            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit) { printf("..."); break; }
                printf("%d",INTEGER(e)[i]);
                if (i < LENGTH(e) - 1) printf(", ");
                i++;
            };
            putchar('\n');
            return;

        case VECSXP:
            printf( "Vector of %d fields:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i>dumpLimit) { printf("..."); break; };
                printSEXP(VECTOR_ELT(e,i));
                i++;
            }
            return;

        case STRSXP:
            printf( "String vector of length %d:\n", LENGTH(e) );
            while( i < LENGTH(e) )
            {
                if (dumpLimit && i > dumpLimit) { printf("..."); break; };
                printSEXP(VECTOR_ELT(e,i)); i++;
            }
            return;

        case CHARSXP:
            printf( "scalar string: \"%s\"\n",(char*) STRING_PTR(e) );
            return;

        case SYMSXP:
            printf( "Symbol, name: "); printSEXP(PRINTNAME(e) );
            return;

        default:
            printf( "Unknown type: %d\n", TYPEOF(e) );
    }
};

}
