/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#ifndef ART_THEME_H_
#define ART_THEME_H_

#include "aRTcomponent.h"

#include <TeTheme.h>

extern "C" {

// aRTthemes can't be populated
// but we can select data and build temporal series
class aRTtheme: public aRTcomponentLeaf
{
	public:
		aRTtheme(TeDatabase* database, string name);
		~aRTtheme();

		void SetAR(string restriction);
		void SetTR(string restriction);
		void SetSR(string restriction);
		void SetVisible(SEXP visible);
		
		SEXP GetData();
		SEXP GetAttributes();
		SEXP GetGeometry();
		SEXP GetBox();
		SEXP GetRaster();
		SEXP GetVisual();

		void SetVisual(SEXP visual);

		void ClearRestrictions();
//		aRTcomponent* Open(string, bool, string) { return NULL; }
		aRTcomponent* Open(SEXP data);
		SEXP List() { return R_NilValue; }
		SEXP Summary();
		const string Print();

		void Save(string viewname=NULL);
		//bool SelectTables(SEXP tableNames);
		string Class() { return "aRTtheme"; }
		TeTheme* Theme() { return TeUtils::GetThemeFromDatabase(Database, ThemeName); }
	private:
		TeDatabase* Database;
		string ThemeName;

		bool QueryValid(); // return if the restrictions are valid	
		bool Parse(char* string, char* error);
};

}

#endif

