/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#ifndef ART_TABLE_H_
#define ART_TABLE_H_

#include "aRTcomponent.h"
#include "aRTlayer.h"

#include <TeTable.h>

extern "C" {

class aRTtable : public aRTcomponentLeaf {
	public:
		aRTtable(TeDatabase* db, string layer, string tablename);
		~aRTtable();

		void CreateLinkIds(string idname);

		virtual void CreateRelation(SEXP data);
		virtual void CreateColumn  (SEXP data);
		virtual void AddRows       (SEXP data);
		virtual void UpdateColumns (SEXP data);
	
		virtual void Create(SEXP data) = 0; // create the table
		
		virtual SEXP GetData();
		
		aRTcomponent* Open(SEXP) { return NULL; }
		virtual SEXP Summary();
		virtual const string Print(); 
		SEXP List() { return R_NilValue; }
		string Class() { return "aRTtable"; }
		bool IsValid();
		string Name() { return TableName; }
		TeLayer* Layer() { return TeUtils::GetLayerFromDatabase(Database, LayerName); }
	protected:
		string TableName;
		string LayerName;
		TeDatabase* Database;
};

}

#endif

