/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#ifndef ART_PROXY_H_
#define ART_PROXY_H_

#include "aRTcomponent.h"
#include "aRTlayer.h"
#include "SEXPutils.h"

#include <TeQuerier.h>

#include <sstream>

extern "C" {

class aRTproxy : public aRTcomponentLeaf {
	public:
		aRTproxy(TeQuerierParams& params);
//		aRTproxy(TeTheme* theme, bool loadgeom, bool loadatt);
		~aRTproxy();

		SEXP GetNext();

		void LoadNextSlide();
		
		aRTcomponent* Open(SEXP) { return NULL; }
		SEXP Summary();
		const string Print(); 
		SEXP List() { return R_NilValue; }
		string Class() { return "aRTlayer"; }
		bool IsValid();
	private:
		int ActualSlide;
		TeQuerier* Querier;
};

}

#endif

