/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#include "aRTproxy.h"
#include "SEXPutils.h"

using namespace std;

TeChronon GetTeChronon(string value)
{
	switch(value[0])
	{
		case 'n': return TeNOCHRONON;
		case 'y': return TeYEAR;
		case 's': return TeSECOND;
		case 'c': return TeSEASON;
		case 'f': return TeSECONDOFMINUTE;
		case 'v': return TeWEEKOFYEAR;
		case 'm':
			switch(value[2])
			{
				case 'i': return value.size() == 6? TeMINUTE : TeMINUTEOFHOUR;
				case 'o': return value.size() == 5? TeMONTH  : TeMONTHOFYEAR;
			}
		case 'h': return value.size() == 4? TeHOUR : TeHOUROFDAY;
		case 'd':
			if(value.size() == 3) return TeDAY;
			switch(value[5])
			{
				case 'w': return TeDAYOFWEEK;
        		case 'm': return TeDAYOFMONTH;
				case 'y': return TeDAYOFYEAR;
			}
	}
}

TeStatisticType GetTeStatisticType(string value)
{
	switch(value[0])
	{
        case 'a': return TeAMPLITUDE;
		case 'n': return TeNOSTATISTIC;
		case 'c': return TeCOUNT;
		case 'k': return value[1] == 'e'? TeKERNEL : TeKURTOSIS;
		case 's':
			switch(value[1])
			{
				case 'u': return TeSUM;
				case 't': return TeSTANDARDDEVIATION;
				case 'k': return TeSKEWNESS;
			}
		case 'm':
			switch(value[1])
			{
				case 'a': return TeMAXVALUE;
				case 'i': return TeMINVALUE;
				case 'e': return value[2] == 'a'? TeMEAN : TeMEDIAN;
				case 'o': return TeMODE;
			}
		case 'v':
			switch(value[4])
			{
				case 'd': return TeVALIDCOUNT;
				case 'o': return TeVARCOEFF;
				case 'a': return TeVARIANCE;
			}
	}
}

aRTproxy::aRTproxy(TeQuerierParams& params)//Layer* layer, bool loadgeom, bool loadatt)
{
	cout << "aRTproxy::ap" << endl;
	TeInitQuerierStrategies(); // never forget it!

//    TeQuerierParams params(loadgeom, loadatt); 
//    params.setParams(layer);

//	params.setParams (TeTheme *theme, TeChronon chr, const string &table, const string &col, TeStatisticType oper)
	
	cout << "new" << endl;
	Querier = new TeQuerier(params);
	cout << "load" << endl;
	Querier->loadInstances();
	cout << "fim load" << endl;

	ActualSlide = -1;
	cout << "fim aRTproxy::ap" << endl;
}

SEXP aRTproxy::GetNext()
{
	TeSTInstance sti;
	TeMultiGeometry mg;

    if( !Querier->fetchInstance(sti) )
	{
		warning("Could not fetch the instance\n");
		return R_NilValue;
	}

	mg = sti.geometries();

	if( mg.hasPolygons() ) return GetPolygonsTeMultiGeometry(mg);
	if( mg.hasLines()    ) return GetLinesTeMultiGeometry(mg);
	if( mg.hasPoints()   ) return GetPointsTeMultiGeometry(mg);
	
	return R_NilValue;
}

aRTproxy::~aRTproxy()
{
	PrintSilent("Deleting one aRTproxy object from memory\n");
	delete Querier;
}
	
// this is the order to appear inside R. S is from Summary
enum aRTproxySenum
{
	aRTproxySClass = 0,
	aRTproxySElements,
	aRTproxySSize
};
					   
SEXP aRTproxy::Summary()
{
    SEXP info, names;

	info    = allocVector(VECSXP, aRTproxySSize);  // List containing the connection attributes
    names   = allocVector(STRSXP, aRTproxySSize);  // Names Vector

	STRING_LIST_ITEM(info, names, aRTproxySClass,    "class",    Class());
    DOUBLE_LIST_ITEM(info, names, aRTproxySElements, "elements", Querier->numElemInstances());

	setAttrib(info, R_NamesSymbol, names); // Set the names of the list

    return info;
}

const string aRTproxy::Print()
{
	stringstream s;

	if (!IsValid()) error("Invalid object!");
		 
	 s << artOBJECT("aRTproxy")   << "\n\n"
       << "Elements: "     << Querier->numElemInstances()  << endl
	   << "Slides: "       << Querier->getNumTimeFrames()      << endl
	   << "Actual slide: " << ActualSlide                  << endl;

	TeTemporalSeries ts;
	if( Querier->getTS (ts) )
	{
		s << "Temporal Series:" << "\n\n"
	      << "";
	}
	else
		s << "No temporal serie" << endl;

	return s.str();
}

void aRTproxy::LoadNextSlide()
{

}

bool aRTproxy::IsValid()
{
	if(Valid && !Querier)
	{
		Valid = false;
	}

	return Valid;
}

