/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

// aRTdb.cpp - Implementation of the class aRTdb, a database object
 
#ifndef ART_DB_H_
#define ART_DB_H_

#include "aRTcomponent.h"
#include "aRTdlcommon.h"
#include "aRTlayer.h"

extern "C"
{

class aRTdb : public aRTcomponentRoot, public aRTdlcommon
{
	public:
		aRTdb(TeDatabase* database);
		~aRTdb();

		aRTcomponent* Open (SEXP data);
		aRTcomponent* OpenTable(SEXP options);
		aRTcomponent* OpenTheme(string theme_name);

		aRTcomponent* ImportShape(string shape_file_name, string layer_name, TeProjection* proj);
		SEXP Summary();
		SEXP List();
		const string Print();
		SEXP ShowViews();
		SEXP ShowThemes();
		SEXP ShowTables();

		void CreateView (string view_name);
		
		void DeleteLayer(string layer_name);
		void DeleteView (string view_name);
		void DeleteTheme(string theme_name);

		string Class() { return "aRTdb"; }
};

}

#endif
