/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#include <iostream>
#include "aRTcomponent.h"

using namespace std;

bool aRTcomponent::Silent = false;

aRTcomponentLeaf::aRTcomponentLeaf() : aRTcomponent()
{
	Parent = NULL;
	Valid  = true;
}

void aRTcomponentLeaf::Clear()
{
	if(Parent) Parent->RemoveChild(this);
	SetInvalid();
}

void aRTcomponentRoot::RemoveChild(aRTcomponentLeaf* child)
{
    list<aRTcomponentLeaf*>::iterator it;

	for(it = Children.begin(); *it != child; it++);

	Children.erase(it);
}

void aRTcomponentRoot::AddChild(aRTcomponentLeaf* child)
{
    child->Parent = this;
    Children.push_back(child);
}

void aRTcomponentLeaf::SetInvalid()
{
    Valid = false;
}

void aRTcomponentRoot::Clear()
{
	list<aRTcomponentLeaf*>::iterator it = Children.begin();
	
	while(it != Children.end())
	{
		(*it)->SetInvalid();
		it++;
	}	
}

// == some functions of tl objects
namespace TeUtils
{

TeViewNode* GetThemeFromView(TeView* view, string theme_name)
{
	vector<TeViewNode*> themeVector = view->themes();

    for (unsigned i = 0; i < themeVector.size(); ++i)
        if (themeVector[i]->name() == theme_name)
		    return themeVector[i];
		
	return NULL;
}

TeView* GetViewFromDatabase(TeDatabase* database, string view_name)
{
    TeViewMap& view_map = database -> viewMap();

    for (TeViewMap::iterator it = view_map.begin(); it != view_map.end(); ++it)
        if( it -> second -> name() == view_name )
			return it->second;

	return NULL;
}

TeTheme* GetThemeFromLayer(TeLayer* layer, string theme_name)
{
	return GetThemeFromDatabase(layer->database(), theme_name);
}

TeLayer* GetLayerFromDatabase(TeDatabase* database, string layer_name)
{
    TeLayerMap& layer_map = database -> layerMap();
    TeLayerMap::iterator it;

    for (it = layer_map.begin(); it != layer_map.end(); ++it)
        if(it-> second -> name() == layer_name)
            return it->second;

    return NULL;
}

TeTheme* GetThemeFromDatabase(TeDatabase* database, string theme_name)
{
    TeThemeMap& theme_map = database -> themeMap();
    TeThemeMap::iterator it;

    for (it = theme_map.begin(); it != theme_map.end(); ++it)
        if(it-> second -> name() == theme_name)
            return it->second;

    return NULL;
}

}

