/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

//  aRT.h - class aRT, implements a "virtual" SGBD connection

#ifndef ART_H_
#define ART_H_

#include "aRTcomponent.h"
#include "aRTdb.h"

#ifdef HAVE_MYSQL
	#include <TeMySQL.h>
#endif

#ifdef HAVE_POSTGRE 
	#include <TePGInterface.h>
	#include <TePGUtils.h>
	#include <TePostgreSQL.h>
#endif

#include <sstream>

#ifndef uint
#define uint unsigned
#endif

enum aRTdatabaseType
{
	aRTmySQL,
	aRTpostgres
	// ...
};

class aRT : public aRTcomponent
{
	public:
		aRT(string user,
		    string pass,
		    uint Port,
		    string host,
		    string dbms);

		SEXP Summary();
		const string Print();
		aRTcomponent* Open(SEXP data);
		void DeleteDb(string dbname);
		void AddUser(string username);

		SEXP List();
        string Class() { return "aRT"; }
	private:
		TeDatabase* NewTeDatabase();

		string User;
		string Password;
		uint Port;
		string Host;
		aRTdatabaseType Type;
};

#endif
