/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#ifndef SEXP_UTILS_H_
#define SEXP_UTILS_H_

#include <string>

#include <TeGeometry.h>
#include <TeThemeApplication.h>
#include <TeQuerier.h>
#include <TeQuerierParams.h>
#include <TeInitQuerierStrategy.h>
#include <TeThemeApplication.h>
#include <TeDecoderMemoryMap.h>
#include <TeInitRasterDecoders.h>
#include <TeRaster.h>
#include <TeImportRaster.h>

#include <TeProjection.h>

#include "TeDecoderSEXP.h"
#include "SEXPbasic.h"

extern "C" {

namespace SEXPutils
{

using namespace std;

  TeProjection* GetTeProjection(string proj4);

  vector<TeColor> SEXPToColors(SEXP colors);
  void SetColors(TeRasterParams& params, vector<TeColor> colors);

  SEXP GetBoxTeBox            (TeBox box);
  SEXP GetPointsTePointSet    (TePointSet& ps);
  SEXP GetPolygonsTePolygonSet(TePolygonSet& ps);
  SEXP GetLinesTeLineSet      (TeLineSet& ls);

  TeVisual     GetTeVisual    (SEXP sxp, TeGeomRep geomrep);
  TePointSet   GetTePointSet  (SEXP sxp);
  TePolygonSet GetTePolygonSet(SEXP sxp);
  TeLineSet    GetTeLineSet   (SEXP sxp);

  SEXP GetThemeData      (TeTheme*);
  SEXP GetThemeGeometry  (TeTheme*);
  SEXP GetThemeAttributes(TeTheme*);
  
  SEXP GetLayerData      (TeLayer*);
  SEXP GetLayerGeometry  (TeLayer*);
  SEXP GetLayerAttributes(TeLayer*);
  
  SEXP GetQuerierData      (TeQuerier*);
  SEXP GetQuerierGeometry  (TeQuerier*);
  SEXP GetQuerierAttributes(TeQuerier*);

  SEXP GetPolygonsTeMultiGeometry(TeMultiGeometry&);
  SEXP GetLinesTeMultiGeometry   (TeMultiGeometry&);
  SEXP GetPointsTeMultiGeometry  (TeMultiGeometry&);
  SEXP GetCellsTeMultiGeometry   (TeMultiGeometry&);

  bool AddRaster(TeLayer* layer, SEXP sraster);

  // strings
  string AttrDataType(TeAttrDataType value);
  string AttrTableType(TeAttrTableType value);
  
  #define dumpLimit 3
  
  void printSEXP(SEXP);
  void printAttrib(SEXP e);
}

}

#endif
